/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.dsmlv2.response;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.dsmlv2.DsmlDecorator;
import org.apache.directory.api.dsmlv2.response.AbstractResponseDsml;
import org.apache.directory.api.dsmlv2.response.SearchResponse;
import org.apache.directory.api.dsmlv2.response.SearchResultDoneDsml;
import org.apache.directory.api.dsmlv2.response.SearchResultEntryDsml;
import org.apache.directory.api.dsmlv2.response.SearchResultReferenceDsml;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.api.ldap.model.message.SearchResultDone;
import org.apache.directory.api.ldap.model.message.SearchResultEntry;
import org.apache.directory.api.ldap.model.message.SearchResultReference;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;

public class SearchResponseDsml
extends AbstractResponseDsml<Response> {
    private static final String SEARCH_RESPONSE_TAG = "searchResponse";
    private List<DsmlDecorator<? extends Response>> responses = new ArrayList<DsmlDecorator<? extends Response>>();

    public SearchResponseDsml(LdapApiService codec) {
        super(codec, new SearchResponse());
    }

    public SearchResponseDsml(LdapApiService codec, Message response) {
        super(codec, (Response)response);
    }

    public boolean addResponse(DsmlDecorator<? extends Response> response) {
        if (response instanceof SearchResultEntry) {
            ((SearchResponse)this.getDecorated()).addSearchResultEntry((SearchResultEntryDsml)response);
        } else if (response instanceof SearchResultReference) {
            ((SearchResponse)this.getDecorated()).addSearchResultReference((SearchResultReferenceDsml)response);
        } else if (response instanceof SearchResultDone) {
            ((SearchResponse)this.getDecorated()).setSearchResultDone((SearchResultDoneDsml)response);
        } else {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_03045_UNIDENTIFIED_RESPONSE_TYPE, new Object[0]));
        }
        return this.responses.add(response);
    }

    public boolean removeResponse(DsmlDecorator<? extends Response> response) {
        if (response instanceof SearchResultEntry) {
            ((SearchResponse)this.getDecorated()).removeSearchResultEntry((SearchResultEntryDsml)response);
        } else if (response instanceof SearchResultReference) {
            ((SearchResponse)this.getDecorated()).removeSearchResultReference((SearchResultReferenceDsml)response);
        } else if (response instanceof SearchResultDone) {
            if (response.equals(((SearchResponse)this.getDecorated()).getSearchResultDone())) {
                ((SearchResponse)this.getDecorated()).setSearchResultDone(null);
            }
        } else {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_03045_UNIDENTIFIED_RESPONSE_TYPE, new Object[0]));
        }
        return this.responses.remove(response);
    }

    @Override
    public Element toDsml(Element root) {
        int requestID;
        Object element = root != null ? root.addElement(SEARCH_RESPONSE_TAG) : new DefaultElement(SEARCH_RESPONSE_TAG);
        if (this.getDecorated() != null && (requestID = ((Response)this.getDecorated()).getMessageId()) > 0) {
            element.addAttribute("requestID", Integer.toString(requestID));
        }
        for (DsmlDecorator<? extends Response> response : this.responses) {
            response.toDsml((Element)element);
        }
        return element;
    }
}

