/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.response.compare;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.CompareResponseDecorator;
import org.apache.directory.api.ldap.model.message.CompareResponseImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitCompareResponse
extends GrammarAction<LdapMessageContainer<CompareResponseDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitCompareResponse.class);

    public InitCompareResponse() {
        super("Compare Response initialization");
    }

    @Override
    public void action(LdapMessageContainer<CompareResponseDecorator> container) throws DecoderException {
        CompareResponseDecorator compareResponse = new CompareResponseDecorator(container.getLdapCodecService(), new CompareResponseImpl(container.getMessageId()));
        container.setMessage(compareResponse);
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err(I18n.ERR_05148_NULL_COMPARE_REQUEST, new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_05169_COMPARE_RESPONSE, new Object[0]));
        }
    }
}

