/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.response.search.entry;

import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.SearchResultEntryDecorator;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreSearchResultAttributeValue
extends GrammarAction<LdapMessageContainer<SearchResultEntryDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreSearchResultAttributeValue.class);

    public StoreSearchResultAttributeValue() {
        super("Stores AttributeValue");
    }

    @Override
    public void action(LdapMessageContainer<SearchResultEntryDecorator> container) {
        SearchResultEntryDecorator searchResultEntry = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        Object value = null;
        try {
            if (tlv.getLength() == 0) {
                searchResultEntry.addAttributeValue("");
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_05180_NULL_ATTRIBUTE_VALUE, new Object[0]));
                }
            } else {
                if (container.isBinary(searchResultEntry.getCurrentAttribute().getId())) {
                    value = tlv.getValue().getData();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg(I18n.MSG_05181_ATTRIBUTE_VALUE, Strings.dumpBytes(value)));
                    }
                } else {
                    value = Strings.utf8ToString(tlv.getValue().getData());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg(I18n.MSG_05181_ATTRIBUTE_VALUE, value));
                    }
                }
                searchResultEntry.addAttributeValue(value);
            }
        }
        catch (LdapException ldapException) {
            // empty catch block
        }
        container.setGrammarEndAllowed(true);
    }
}

