/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.decorators.SingleReplyRequestDecorator;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.util.Strings;

public class ExtendedRequestDecorator<Q extends ExtendedRequest>
extends SingleReplyRequestDecorator<Q>
implements ExtendedRequest {
    private int extendedRequestLength;
    private byte[] requestNameBytes;
    protected byte[] requestValue;

    public ExtendedRequestDecorator(LdapApiService codec, Q decoratedMessage) {
        super(codec, decoratedMessage);
    }

    @Override
    public String getRequestName() {
        return ((ExtendedRequest)this.getDecorated()).getRequestName();
    }

    @Override
    public ExtendedRequest setRequestName(String oid) {
        ((ExtendedRequest)this.getDecorated()).setRequestName(oid);
        return this;
    }

    public byte[] getRequestValue() {
        return this.requestValue;
    }

    public void setRequestValue(byte[] requestValue) {
        this.requestValue = requestValue;
    }

    @Override
    public ExtendedRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    @Override
    public ExtendedRequest addControl(Control control) {
        return (ExtendedRequest)super.addControl(control);
    }

    @Override
    public ExtendedRequest addAllControls(Control[] controls) {
        return (ExtendedRequest)super.addAllControls(controls);
    }

    @Override
    public ExtendedRequest removeControl(Control control) {
        return (ExtendedRequest)super.removeControl(control);
    }

    @Override
    public int computeLength() {
        this.requestNameBytes = Strings.getBytesUtf8(this.getRequestName());
        this.extendedRequestLength = 1 + TLV.getNbBytes(this.requestNameBytes.length) + this.requestNameBytes.length;
        if (this.getRequestValue() != null) {
            this.extendedRequestLength += 1 + TLV.getNbBytes(this.getRequestValue().length) + this.getRequestValue().length;
        }
        return 1 + TLV.getNbBytes(this.extendedRequestLength) + this.extendedRequestLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)119);
            buffer.put(TLV.getBytes(this.extendedRequestLength));
            if (this.requestNameBytes == null) {
                throw new EncoderException(I18n.err(I18n.ERR_05000_NULL_REQUEST_NAME, new Object[0]));
            }
            buffer.put((byte)-128);
            buffer.put(TLV.getBytes(this.requestNameBytes.length));
            if (this.requestNameBytes.length != 0) {
                buffer.put(this.requestNameBytes);
            }
            if (this.getRequestValue() != null) {
                buffer.put((byte)-127);
                buffer.put(TLV.getBytes(this.getRequestValue().length));
                if (this.getRequestValue().length != 0) {
                    buffer.put(this.getRequestValue());
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_08212_PDU_BUFFER_TOO_SMALL, new Object[0]), boe);
        }
        return buffer;
    }
}

