/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.protocol.mina;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.tlv.TLVStateEnum;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.MessageDecorator;
import org.apache.directory.api.ldap.codec.api.ResponseCarryingException;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.exception.ResponseCarryingMessageException;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.util.Strings;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapProtocolDecoder
implements ProtocolDecoder {
    private static final Logger CODEC_LOG = LoggerFactory.getLogger((String)Loggers.CODEC_LOG.getName());
    private Asn1Decoder asn1Decoder = new Asn1Decoder();

    public void decode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        LdapMessageContainer messageContainer = (LdapMessageContainer)session.getAttribute((Object)"LDAP-container");
        if (session.containsAttribute((Object)"LDAP-maxPduSize")) {
            int maxPDUSize = (Integer)session.getAttribute((Object)"LDAP-maxPduSize");
            messageContainer.setMaxPDUSize(maxPDUSize);
        }
        ArrayList<Message> decodedMessages = new ArrayList<Message>();
        ByteBuffer buf = in.buf();
        this.decode(buf, messageContainer, decodedMessages);
        for (Message message : decodedMessages) {
            out.write((Object)message);
        }
    }

    private void decode(ByteBuffer buffer, LdapMessageContainer<MessageDecorator<? extends Message>> messageContainer, List<Message> decodedMessages) throws DecoderException {
        buffer.mark();
        while (buffer.hasRemaining()) {
            try {
                if (CODEC_LOG.isDebugEnabled()) {
                    CODEC_LOG.debug(I18n.msg(I18n.MSG_14000_DECODING_PDU, new Object[0]));
                    int size = buffer.limit();
                    int position = buffer.position();
                    int pduLength = size - position;
                    byte[] array = new byte[pduLength];
                    System.arraycopy(buffer.array(), position, array, 0, pduLength);
                    if (array.length == 0) {
                        CODEC_LOG.debug(I18n.msg(I18n.MSG_14001_NULL_BUFFER, new Object[0]));
                    } else {
                        CODEC_LOG.debug(Strings.dumpBytes(array));
                    }
                }
                this.asn1Decoder.decode(buffer, messageContainer);
                if (messageContainer.getState() != TLVStateEnum.PDU_DECODED) continue;
                if (CODEC_LOG.isDebugEnabled()) {
                    CODEC_LOG.debug(I18n.msg(I18n.MSG_14002_DECODED_LDAP_MESSAGE, messageContainer.getMessage()));
                }
                MessageDecorator<? extends Message> message = messageContainer.getMessage();
                decodedMessages.add(message);
                messageContainer.clean();
            }
            catch (ResponseCarryingException rce) {
                buffer.clear();
                messageContainer.clean();
                ResponseCarryingMessageException rcme = new ResponseCarryingMessageException(rce.getMessage(), rce);
                rcme.setResponse(rce.getResponse());
                throw rcme;
            }
            catch (DecoderException de) {
                buffer.clear();
                messageContainer.clean();
                throw new ResponseCarryingException(de.getMessage(), de);
            }
        }
    }

    public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
    }

    public void dispose(IoSession session) throws Exception {
    }
}

