/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.decorators.ExtendedResponseDecorator;
import org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify.PasswordModifyResponseDecoder;
import org.apache.directory.api.ldap.extras.extended.pwdModify.PasswordModifyResponse;
import org.apache.directory.api.ldap.extras.extended.pwdModify.PasswordModifyResponseImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordModifyResponseDecorator
extends ExtendedResponseDecorator<PasswordModifyResponse>
implements PasswordModifyResponse {
    private static final Logger LOG = LoggerFactory.getLogger(PasswordModifyResponseDecorator.class);
    private PasswordModifyResponse passwordModifyResponse;
    private int responseLength = 0;

    public PasswordModifyResponseDecorator(LdapApiService codec, PasswordModifyResponse decoratedMessage) {
        super(codec, decoratedMessage);
        this.passwordModifyResponse = decoratedMessage;
    }

    @Override
    public void setResponseValue(byte[] responseValue) {
        PasswordModifyResponseDecoder decoder = new PasswordModifyResponseDecoder();
        try {
            if (responseValue != null) {
                this.passwordModifyResponse = decoder.decode(responseValue);
                this.responseValue = new byte[responseValue.length];
                System.arraycopy(responseValue, 0, this.responseValue, 0, responseValue.length);
            } else {
                this.responseValue = null;
            }
        }
        catch (DecoderException e) {
            LOG.error(I18n.err(I18n.ERR_08217_PAYLOAD_DECODING_ERROR, new Object[0]), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] getResponseValue() {
        if (this.responseValue == null) {
            this.responseValue = this.encodeInternal().array();
        }
        return this.responseValue;
    }

    @Override
    public byte[] getGenPassword() {
        return ((PasswordModifyResponse)this.getDecorated()).getGenPassword();
    }

    public void setGenPassword(byte[] genPassword) {
        ((PasswordModifyResponseImpl)this.getDecorated()).setGenPassword(genPassword);
    }

    @Override
    public String getResponseName() {
        return null;
    }

    int computeLengthInternal() {
        this.responseLength = 0;
        if (this.passwordModifyResponse.getGenPassword() != null) {
            int len = this.passwordModifyResponse.getGenPassword().length;
            this.responseLength = 1 + TLV.getNbBytes(len) + len;
        }
        return 1 + TLV.getNbBytes(this.responseLength) + this.responseLength;
    }

    ByteBuffer encodeInternal() {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLengthInternal());
        bb.put(UniversalTag.SEQUENCE.getValue());
        bb.put(TLV.getBytes(this.responseLength));
        if (this.passwordModifyResponse.getGenPassword() != null) {
            byte[] userIdentity = this.passwordModifyResponse.getGenPassword();
            bb.put((byte)-128);
            bb.put(TLV.getBytes(userIdentity.length));
            bb.put(userIdentity);
        }
        return bb;
    }
}

