/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.storedProcedure;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.storedProcedure.StoredProcedureContainer;
import org.apache.directory.api.ldap.extras.extended.ads_impl.storedProcedure.StoredProcedureRequestDecorator;
import org.apache.directory.api.ldap.extras.extended.ads_impl.storedProcedure.StoredProcedureStatesEnum;
import org.apache.directory.api.ldap.extras.extended.storedProcedure.StoredProcedureParameter;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StoredProcedureGrammar
extends AbstractGrammar<StoredProcedureContainer> {
    static final Logger LOG = LoggerFactory.getLogger(StoredProcedureGrammar.class);
    private static StoredProcedureGrammar instance = new StoredProcedureGrammar();

    private StoredProcedureGrammar() {
        this.setName(StoredProcedureGrammar.class.getName());
        this.transitions = new GrammarTransition[StoredProcedureStatesEnum.LAST_STORED_PROCEDURE_STATE.ordinal()][256];
        this.transitions[StoredProcedureStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition(StoredProcedureStatesEnum.START_STATE, StoredProcedureStatesEnum.STORED_PROCEDURE_STATE, UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[StoredProcedureStatesEnum.STORED_PROCEDURE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<StoredProcedureContainer>(StoredProcedureStatesEnum.STORED_PROCEDURE_STATE, StoredProcedureStatesEnum.LANGUAGE_STATE, UniversalTag.OCTET_STRING.getValue(), new GrammarAction<StoredProcedureContainer>("Stores the language"){

            @Override
            public void action(StoredProcedureContainer container) throws DecoderException {
                TLV tlv = container.getCurrentTLV();
                StoredProcedureRequestDecorator storedProcedure = container.getStoredProcedure();
                if (storedProcedure == null) {
                    storedProcedure = new StoredProcedureRequestDecorator(LdapApiServiceFactory.getSingleton());
                    container.setStoredProcedure(storedProcedure);
                }
                if (tlv.getLength() == 0) {
                    String msg = I18n.err(I18n.ERR_08207_SP_LANGUAGE_NULL, new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                String language = Strings.utf8ToString(tlv.getValue().getData());
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_08213_SP_LANGUAGE_FOUND, language));
                }
                storedProcedure.setLanguage(language);
            }
        });
        this.transitions[StoredProcedureStatesEnum.LANGUAGE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<StoredProcedureContainer>(StoredProcedureStatesEnum.LANGUAGE_STATE, StoredProcedureStatesEnum.PROCEDURE_STATE, UniversalTag.OCTET_STRING.getValue(), new GrammarAction<StoredProcedureContainer>("Stores the procedure"){

            @Override
            public void action(StoredProcedureContainer container) throws DecoderException {
                TLV tlv = container.getCurrentTLV();
                StoredProcedureRequestDecorator storedProcedure = container.getStoredProcedure();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err(I18n.ERR_08208_NULL_PROCEDURE, new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                byte[] procedure = tlv.getValue().getData();
                storedProcedure.setProcedure(procedure);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_08212_PROCEDURE_FOUND, storedProcedure.getProcedureSpecification()));
                }
            }
        });
        this.transitions[StoredProcedureStatesEnum.PROCEDURE_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition<StoredProcedureContainer>(StoredProcedureStatesEnum.PROCEDURE_STATE, StoredProcedureStatesEnum.PARAMETERS_STATE, UniversalTag.SEQUENCE.getValue(), new GrammarAction<StoredProcedureContainer>("Stores the parameters"){

            @Override
            public void action(StoredProcedureContainer container) {
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[StoredProcedureStatesEnum.PARAMETERS_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition(StoredProcedureStatesEnum.PARAMETERS_STATE, StoredProcedureStatesEnum.PARAMETER_STATE, UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[StoredProcedureStatesEnum.PARAMETER_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<StoredProcedureContainer>(StoredProcedureStatesEnum.PARAMETER_STATE, StoredProcedureStatesEnum.PARAMETER_TYPE_STATE, UniversalTag.OCTET_STRING.getValue(), new GrammarAction<StoredProcedureContainer>("Store parameter type"){

            @Override
            public void action(StoredProcedureContainer container) throws DecoderException {
                TLV tlv = container.getCurrentTLV();
                StoredProcedureRequestDecorator storedProcedure = container.getStoredProcedure();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err(I18n.ERR_08209_NULL_PARAMETER_TYPE, new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                StoredProcedureParameter parameter = new StoredProcedureParameter();
                byte[] parameterType = tlv.getValue().getData();
                parameter.setType(parameterType);
                storedProcedure.setCurrentParameter(parameter);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_08210_PARAMETER_TYPE_FOUND, Strings.dumpBytes(parameterType)));
                }
            }
        });
        this.transitions[StoredProcedureStatesEnum.PARAMETER_TYPE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<StoredProcedureContainer>(StoredProcedureStatesEnum.PARAMETER_TYPE_STATE, StoredProcedureStatesEnum.PARAMETER_VALUE_STATE, UniversalTag.OCTET_STRING.getValue(), new GrammarAction<StoredProcedureContainer>("Store parameter value"){

            @Override
            public void action(StoredProcedureContainer container) throws DecoderException {
                StoredProcedureContainer storedProcedureContainer = container;
                TLV tlv = storedProcedureContainer.getCurrentTLV();
                StoredProcedureRequestDecorator storedProcedure = storedProcedureContainer.getStoredProcedure();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err(I18n.ERR_08210_NULL_PARAMETER_VALUE, new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                byte[] parameterValue = tlv.getValue().getData();
                if (parameterValue.length != 0) {
                    StoredProcedureParameter parameter = storedProcedure.getCurrentParameter();
                    parameter.setValue(parameterValue);
                    storedProcedure.addParameter(parameter);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg(I18n.MSG_08211_PARAMETER_VALUE_FOUND, Strings.dumpBytes(parameterValue)));
                    }
                } else {
                    String msg = I18n.err(I18n.ERR_08211_EMPTY_PARAMETER_VALUE, new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[StoredProcedureStatesEnum.PARAMETER_VALUE_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition(StoredProcedureStatesEnum.PARAMETER_VALUE_STATE, StoredProcedureStatesEnum.PARAMETER_STATE, UniversalTag.SEQUENCE.getValue(), null);
    }

    public static StoredProcedureGrammar getInstance() {
        return instance;
    }
}

