/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema;

import java.util.List;
import java.util.Map;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.DitContentRule;
import org.apache.directory.api.ldap.model.schema.DitStructureRule;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.MatchingRuleUse;
import org.apache.directory.api.ldap.model.schema.NameForm;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.ldap.model.schema.registries.Schema;
import org.apache.directory.api.util.DateUtils;

public class AttributesFactory {
    public Entry getAttributes(SchemaObject obj, Schema schema, SchemaManager schemaManager) throws LdapException {
        if (obj instanceof LdapSyntax) {
            return this.convert((LdapSyntax)obj, schema, schemaManager);
        }
        if (obj instanceof MatchingRule) {
            return this.convert((MatchingRule)obj, schema, schemaManager);
        }
        if (obj instanceof AttributeType) {
            return this.convert((AttributeType)obj, schema, schemaManager);
        }
        if (obj instanceof ObjectClass) {
            return this.convert((ObjectClass)obj, schema, schemaManager);
        }
        if (obj instanceof MatchingRuleUse) {
            return this.convert((MatchingRuleUse)obj, schema, schemaManager);
        }
        if (obj instanceof DitStructureRule) {
            return this.convert((DitStructureRule)obj, schema, schemaManager);
        }
        if (obj instanceof DitContentRule) {
            return this.convert((DitContentRule)obj, schema, schemaManager);
        }
        if (obj instanceof NameForm) {
            return this.convert((NameForm)obj, schema, schemaManager);
        }
        throw new IllegalArgumentException(I18n.err(I18n.ERR_13712_UNKNOWN_SCHEMA_OBJECT_TYPE, obj.getClass()));
    }

    public Entry convert(Schema schema, SchemaManager schemaManager) throws LdapException {
        String[] dependencies;
        DefaultEntry entry = new DefaultEntry(schemaManager);
        entry.put("objectClass", "top", "metaSchema");
        entry.put("cn", schema.getSchemaName());
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        if (schema.isDisabled()) {
            entry.put("m-disabled", "TRUE");
        }
        if ((dependencies = schema.getDependencies()) != null && dependencies.length > 0) {
            DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("m-dependencies"));
            for (String dependency : dependencies) {
                attr.add(dependency);
            }
            entry.put(attr);
        }
        return entry;
    }

    public Entry convert(SyntaxChecker syntaxChecker, Schema schema, SchemaManager schemaManager) {
        DefaultEntry entry = new DefaultEntry(schemaManager);
        entry.put("objectClass", "top", "metaSyntaxChecker");
        entry.put("m-oid", syntaxChecker.getOid());
        entry.put("m-fqcn", syntaxChecker.getClass().getName());
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        return entry;
    }

    public Entry convert(LdapSyntax syntax, Schema schema, SchemaManager schemaManager) throws LdapException {
        DefaultEntry entry = new DefaultEntry(schemaManager);
        entry.put("objectClass", "top", "metaSyntax");
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        this.injectCommon(syntax, entry, schemaManager);
        return entry;
    }

    public Entry convert(String oid, Normalizer normalizer, Schema schema, SchemaManager schemaManager) {
        DefaultEntry entry = new DefaultEntry(schemaManager);
        entry.put("objectClass", "top", "metaNormalizer");
        entry.put("m-oid", oid);
        entry.put("m-fqcn", normalizer.getClass().getName());
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        return entry;
    }

    public Entry convert(String oid, LdapComparator<? super Object> comparator, Schema schema, SchemaManager schemaManager) {
        DefaultEntry entry = new DefaultEntry(schemaManager);
        entry.put("objectClass", "top", "metaComparator");
        entry.put("m-oid", oid);
        entry.put("m-fqcn", comparator.getClass().getName());
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        return entry;
    }

    public Entry convert(MatchingRule matchingRule, Schema schema, SchemaManager schemaManager) throws LdapException {
        DefaultEntry entry = new DefaultEntry(schemaManager);
        entry.put("objectClass", "top", "metaMatchingRule");
        entry.put("m-syntax", matchingRule.getSyntaxOid());
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        this.injectCommon(matchingRule, entry, schemaManager);
        return entry;
    }

    public Entry convert(MatchingRuleUse matchingRuleUse, Schema schema, SchemaManager schemaManager) {
        DefaultEntry entry = new DefaultEntry(schemaManager);
        entry.put("objectClass", "top", "");
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        return entry;
    }

    public Entry convert(DitStructureRule ditStructureRule, Schema schema, SchemaManager schemaManager) {
        DefaultEntry entry = new DefaultEntry(schemaManager);
        entry.put("objectClass", "top", "");
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        return entry;
    }

    public Entry convert(DitContentRule dITContentRule, Schema schema, SchemaManager schemaManager) {
        DefaultEntry entry = new DefaultEntry(schemaManager);
        entry.put("objectClass", "top", "");
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        return entry;
    }

    public Entry convert(NameForm nameForm, Schema schema, SchemaManager schemaManager) {
        DefaultEntry entry = new DefaultEntry(schemaManager);
        entry.put("objectClass", "top", "");
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        return entry;
    }

    public Entry convert(AttributeType attributeType, Schema schema, SchemaManager schemaManager) throws LdapException {
        DefaultEntry entry = new DefaultEntry(schemaManager);
        entry.put("objectClass", "top", "metaAttributeType");
        entry.put("m-collective", this.getBoolean(attributeType.isCollective()));
        entry.put("m-noUserModification", this.getBoolean(!attributeType.isUserModifiable()));
        entry.put("m-singleValue", this.getBoolean(attributeType.isSingleValued()));
        entry.put("m-usage", attributeType.getUsage().toString());
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        this.injectCommon(attributeType, entry, schemaManager);
        String superiorOid = attributeType.getSuperiorOid();
        if (superiorOid != null) {
            entry.put("m-supAttributeType", superiorOid);
        }
        if (attributeType.getEqualityOid() != null) {
            entry.put("m-equality", attributeType.getEqualityOid());
        }
        if (attributeType.getSubstringOid() != null) {
            entry.put("m-substr", attributeType.getSubstringOid());
        }
        if (attributeType.getOrderingOid() != null) {
            entry.put("m-ordering", attributeType.getOrderingOid());
        }
        if (attributeType.getSyntaxOid() != null) {
            entry.put("m-syntax", attributeType.getSyntaxOid());
        }
        return entry;
    }

    public Entry convert(ObjectClass objectClass, Schema schema, SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr;
        DefaultEntry entry = new DefaultEntry(schemaManager);
        entry.put("objectClass", "top", "metaObjectClass");
        entry.put("m-typeObjectClass", objectClass.getType().toString());
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        this.injectCommon(objectClass, entry, schemaManager);
        if (objectClass.getSuperiorOids() != null && !objectClass.getSuperiorOids().isEmpty()) {
            attr = schemaManager != null ? new DefaultAttribute(schemaManager.getAttributeType("m-supObjectClass")) : new DefaultAttribute("m-supObjectClass");
            for (String superior : objectClass.getSuperiorOids()) {
                attr.add(superior);
            }
            entry.put(attr);
        }
        if (objectClass.getMustAttributeTypeOids() != null && !objectClass.getMustAttributeTypeOids().isEmpty()) {
            attr = schemaManager != null ? new DefaultAttribute(schemaManager.getAttributeType("m-must")) : new DefaultAttribute("m-must");
            for (String mustOid : objectClass.getMustAttributeTypeOids()) {
                attr.add(mustOid);
            }
            entry.put(attr);
        }
        if (objectClass.getMayAttributeTypeOids() != null && !objectClass.getMayAttributeTypeOids().isEmpty()) {
            attr = schemaManager != null ? new DefaultAttribute(schemaManager.getAttributeType("m-may")) : new DefaultAttribute("m-may");
            for (String mayOid : objectClass.getMayAttributeTypeOids()) {
                attr.add(mayOid);
            }
            entry.put(attr);
        }
        return entry;
    }

    private void injectCommon(SchemaObject object, Entry entry, SchemaManager schemaManager) throws LdapException {
        Map<String, List<String>> extensions;
        this.injectNames(object.getNames(), entry, schemaManager);
        entry.put("m-obsolete", this.getBoolean(object.isObsolete()));
        entry.put("m-oid", object.getOid());
        if (object.getDescription() != null) {
            entry.put("m-description", object.getDescription());
        }
        if ((extensions = object.getExtensions()) != null) {
            for (Map.Entry<String, List<String>> mapEntry : extensions.entrySet()) {
                String key = mapEntry.getKey();
                List<String> values = mapEntry.getValue();
                for (String value : values) {
                    entry.add(key, value);
                }
            }
        }
    }

    private void injectNames(List<String> names, Entry entry, SchemaManager schemaManager) throws LdapException {
        if (names == null || names.isEmpty()) {
            return;
        }
        DefaultAttribute attr = schemaManager != null ? new DefaultAttribute(schemaManager.getAttributeType("m-name")) : new DefaultAttribute("m-name");
        for (String name : names) {
            attr.add(name);
        }
        entry.put(attr);
    }

    private String getBoolean(boolean value) {
        if (value) {
            return "TRUE";
        }
        return "FALSE";
    }
}

