/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.template;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.extras.controls.ppolicy_impl.PasswordPolicyDecorator;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.AddRequest;
import org.apache.directory.api.ldap.model.message.AddResponse;
import org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.directory.api.ldap.model.message.BindRequestImpl;
import org.apache.directory.api.ldap.model.message.BindResponse;
import org.apache.directory.api.ldap.model.message.DeleteRequest;
import org.apache.directory.api.ldap.model.message.DeleteResponse;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.directory.api.ldap.model.message.ModifyRequestImpl;
import org.apache.directory.api.ldap.model.message.ModifyResponse;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.ldap.client.api.EntryCursorImpl;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionPool;
import org.apache.directory.ldap.client.api.search.FilterBuilder;
import org.apache.directory.ldap.client.template.ConnectionCallback;
import org.apache.directory.ldap.client.template.EntryMapper;
import org.apache.directory.ldap.client.template.LdapConnectionOperations;
import org.apache.directory.ldap.client.template.MemoryClearingBuffer;
import org.apache.directory.ldap.client.template.ModelFactory;
import org.apache.directory.ldap.client.template.ModelFactoryImpl;
import org.apache.directory.ldap.client.template.PasswordPolicyOperation;
import org.apache.directory.ldap.client.template.PasswordPolicyResponder;
import org.apache.directory.ldap.client.template.PasswordPolicyResponderImpl;
import org.apache.directory.ldap.client.template.PasswordWarning;
import org.apache.directory.ldap.client.template.RequestBuilder;
import org.apache.directory.ldap.client.template.exception.LdapRequestUnsuccessfulException;
import org.apache.directory.ldap.client.template.exception.LdapRuntimeException;
import org.apache.directory.ldap.client.template.exception.PasswordException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapConnectionTemplate
implements LdapConnectionOperations,
ModelFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LdapConnectionTemplate.class);
    private static final EntryMapper<Dn> DN_ENTRY_MAPPER = new EntryMapper<Dn>(){

        @Override
        public Dn map(Entry entry) throws LdapException {
            return entry.getDn();
        }
    };
    private LdapConnectionPool connectionPool;
    private final PasswordPolicyDecorator passwordPolicyRequestControl;
    private PasswordPolicyResponder passwordPolicyResponder;
    private ModelFactory modelFactory;

    public LdapConnectionTemplate(LdapConnectionPool connectionPool) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_04174_CREATING_NEW_CONNECTION_TEMPLATE, new Object[0]));
        }
        this.connectionPool = connectionPool;
        this.passwordPolicyRequestControl = new PasswordPolicyDecorator(connectionPool.getLdapApiService());
        this.passwordPolicyResponder = new PasswordPolicyResponderImpl(connectionPool.getLdapApiService());
        this.modelFactory = new ModelFactoryImpl();
    }

    @Override
    public AddResponse add(Dn dn, final Attribute ... attributes) {
        return this.add(dn, new RequestBuilder<AddRequest>(){

            @Override
            public void buildRequest(AddRequest request) throws LdapException {
                request.getEntry().add(attributes);
            }
        });
    }

    @Override
    public AddResponse add(Dn dn, RequestBuilder<AddRequest> requestBuilder) {
        AddRequest addRequest = this.newAddRequest(this.newEntry(dn));
        try {
            requestBuilder.buildRequest(addRequest);
        }
        catch (LdapException e) {
            throw new LdapRuntimeException(e);
        }
        return this.add(addRequest);
    }

    @Override
    public AddResponse add(AddRequest addRequest) {
        LdapConnection connection = null;
        try {
            connection = this.connectionPool.getConnection();
            AddResponse addResponse = connection.add(addRequest);
            return addResponse;
        }
        catch (LdapException e) {
            throw new LdapRuntimeException(e);
        }
        finally {
            this.returnLdapConnection(connection);
        }
    }

    @Override
    public PasswordWarning authenticate(String baseDn, String filter, SearchScope scope, char[] password) throws PasswordException {
        return this.authenticate(this.newSearchRequest(baseDn, filter, scope), password);
    }

    @Override
    public PasswordWarning authenticate(Dn baseDn, String filter, SearchScope scope, char[] password) throws PasswordException {
        return this.authenticate(this.newSearchRequest(baseDn, filter, scope), password);
    }

    @Override
    public PasswordWarning authenticate(SearchRequest searchRequest, char[] password) throws PasswordException {
        Dn userDn = this.searchFirst(searchRequest, DN_ENTRY_MAPPER);
        if (userDn == null) {
            throw new PasswordException().setResultCode(ResultCodeEnum.INVALID_CREDENTIALS);
        }
        return this.authenticate(userDn, password);
    }

    @Override
    public PasswordWarning authenticate(Dn userDn, char[] password) throws PasswordException {
        LdapConnection connection = null;
        try {
            connection = this.connectionPool.getConnection();
            PasswordWarning passwordWarning = this.authenticateConnection(connection, userDn, password);
            return passwordWarning;
        }
        catch (LdapException e) {
            throw new LdapRuntimeException(e);
        }
        finally {
            this.returnLdapConnection(connection);
        }
    }

    private PasswordWarning authenticateConnection(final LdapConnection connection, final Dn userDn, final char[] password) throws PasswordException {
        return this.passwordPolicyResponder.process(new PasswordPolicyOperation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ResultResponse process() throws LdapException {
                MemoryClearingBuffer passwordBuffer = MemoryClearingBuffer.newInstance(password);
                try {
                    BindRequest bindRequest = new BindRequestImpl().setDn(userDn).setCredentials(passwordBuffer.getBytes()).addControl(LdapConnectionTemplate.this.passwordPolicyRequestControl);
                    BindResponse bindResponse = connection.bind(bindRequest);
                    return bindResponse;
                }
                finally {
                    passwordBuffer.clear();
                }
            }
        });
    }

    @Override
    public DeleteResponse delete(Dn dn) {
        return this.delete(dn, null);
    }

    @Override
    public DeleteResponse delete(Dn dn, RequestBuilder<DeleteRequest> requestBuilder) {
        DeleteRequest deleteRequest = this.newDeleteRequest(dn);
        if (requestBuilder != null) {
            try {
                requestBuilder.buildRequest(deleteRequest);
            }
            catch (LdapException e) {
                throw new LdapRuntimeException(e);
            }
        }
        return this.delete(deleteRequest);
    }

    @Override
    public DeleteResponse delete(DeleteRequest deleteRequest) {
        LdapConnection connection = null;
        try {
            connection = this.connectionPool.getConnection();
            DeleteResponse deleteResponse = connection.delete(deleteRequest);
            return deleteResponse;
        }
        catch (LdapException e) {
            throw new LdapRuntimeException(e);
        }
        finally {
            this.returnLdapConnection(connection);
        }
    }

    @Override
    public <T> T execute(ConnectionCallback<T> connectionCallback) {
        LdapConnection connection = null;
        try {
            connection = this.connectionPool.getConnection();
            T t = connectionCallback.doWithConnection(connection);
            return t;
        }
        catch (LdapException e) {
            throw new LdapRuntimeException(e);
        }
        finally {
            this.returnLdapConnection(connection);
        }
    }

    @Override
    public <T> T lookup(Dn dn, EntryMapper<T> entryMapper) {
        return this.lookup(dn, null, entryMapper);
    }

    @Override
    public <T> T lookup(Dn dn, String[] attributes, EntryMapper<T> entryMapper) {
        LdapConnection connection = null;
        try {
            connection = this.connectionPool.getConnection();
            Entry entry = attributes == null ? connection.lookup(dn) : connection.lookup(dn, attributes);
            T t = entry == null ? null : (T)entryMapper.map(entry);
            return t;
        }
        catch (LdapException e) {
            throw new LdapRuntimeException(e);
        }
        finally {
            this.returnLdapConnection(connection);
        }
    }

    private void modifyPassword(final LdapConnection connection, final Dn userDn, final char[] newPassword) throws PasswordException {
        this.passwordPolicyResponder.process(new PasswordPolicyOperation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ResultResponse process() throws PasswordException, LdapException {
                MemoryClearingBuffer newPasswordBuffer = MemoryClearingBuffer.newInstance(newPassword);
                try {
                    ModifyRequest modifyRequest = new ModifyRequestImpl().setName(userDn).replace("userPassword", new byte[][]{newPasswordBuffer.getComputedBytes()}).addControl(LdapConnectionTemplate.this.passwordPolicyRequestControl);
                    ModifyResponse modifyResponse = connection.modify(modifyRequest);
                    return modifyResponse;
                }
                finally {
                    newPasswordBuffer.clear();
                }
            }
        });
    }

    @Override
    public void modifyPassword(Dn userDn, char[] newPassword) throws PasswordException {
        this.modifyPassword(userDn, null, newPassword, true);
    }

    @Override
    public void modifyPassword(Dn userDn, char[] oldPassword, char[] newPassword) throws PasswordException {
        this.modifyPassword(userDn, oldPassword, newPassword, false);
    }

    @Override
    public void modifyPassword(Dn userDn, char[] oldPassword, char[] newPassword, boolean asAdmin) throws PasswordException {
        LdapConnection connection = null;
        try {
            connection = this.connectionPool.getConnection();
            if (!asAdmin) {
                this.authenticateConnection(connection, userDn, oldPassword);
            }
            this.modifyPassword(connection, userDn, newPassword);
        }
        catch (LdapException e) {
            throw new LdapRuntimeException(e);
        }
        finally {
            this.returnLdapConnection(connection);
        }
    }

    @Override
    public ModifyResponse modify(Dn dn, RequestBuilder<ModifyRequest> requestBuilder) {
        ModifyRequest modifyRequest = this.newModifyRequest(dn);
        try {
            requestBuilder.buildRequest(modifyRequest);
        }
        catch (LdapException e) {
            throw new LdapRuntimeException(e);
        }
        return this.modify(modifyRequest);
    }

    @Override
    public ModifyResponse modify(ModifyRequest modifyRequest) {
        LdapConnection connection = null;
        try {
            connection = this.connectionPool.getConnection();
            ModifyResponse modifyResponse = connection.modify(modifyRequest);
            return modifyResponse;
        }
        catch (LdapException e) {
            throw new LdapRuntimeException(e);
        }
        finally {
            this.returnLdapConnection(connection);
        }
    }

    @Override
    public AddRequest newAddRequest(Entry entry) {
        return this.modelFactory.newAddRequest(entry);
    }

    @Override
    public Attribute newAttribute(String name) {
        return this.modelFactory.newAttribute(name);
    }

    @Override
    public Attribute newAttribute(String name, byte[] ... values) {
        return this.modelFactory.newAttribute(name, values);
    }

    @Override
    public Attribute newAttribute(String name, String ... values) {
        return this.modelFactory.newAttribute(name, values);
    }

    @Override
    public Attribute newAttribute(String name, Value ... values) {
        return this.modelFactory.newAttribute(name, values);
    }

    @Override
    public DeleteRequest newDeleteRequest(Dn dn) {
        return this.modelFactory.newDeleteRequest(dn);
    }

    @Override
    public Dn newDn(String dn) {
        return this.modelFactory.newDn(dn);
    }

    @Override
    public Entry newEntry(String dn) {
        return this.modelFactory.newEntry(dn);
    }

    @Override
    public Entry newEntry(Dn dn) {
        return this.modelFactory.newEntry(dn);
    }

    @Override
    public ModifyRequest newModifyRequest(String dn) {
        return this.modelFactory.newModifyRequest(dn);
    }

    @Override
    public ModifyRequest newModifyRequest(Dn dn) {
        return this.modelFactory.newModifyRequest(dn);
    }

    @Override
    public SearchRequest newSearchRequest(String baseDn, FilterBuilder filter, SearchScope scope) {
        return this.modelFactory.newSearchRequest(baseDn, filter, scope);
    }

    @Override
    public SearchRequest newSearchRequest(String baseDn, String filter, SearchScope scope) {
        return this.modelFactory.newSearchRequest(baseDn, filter, scope);
    }

    @Override
    public SearchRequest newSearchRequest(Dn baseDn, FilterBuilder filter, SearchScope scope) {
        return this.modelFactory.newSearchRequest(baseDn, filter, scope);
    }

    @Override
    public SearchRequest newSearchRequest(Dn baseDn, String filter, SearchScope scope) {
        return this.modelFactory.newSearchRequest(baseDn, filter, scope);
    }

    @Override
    public SearchRequest newSearchRequest(String baseDn, FilterBuilder filter, SearchScope scope, String ... attributes) {
        return this.modelFactory.newSearchRequest(baseDn, filter, scope, attributes);
    }

    @Override
    public SearchRequest newSearchRequest(String baseDn, String filter, SearchScope scope, String ... attributes) {
        return this.modelFactory.newSearchRequest(baseDn, filter, scope, attributes);
    }

    @Override
    public SearchRequest newSearchRequest(Dn baseDn, FilterBuilder filter, SearchScope scope, String ... attributes) {
        return this.modelFactory.newSearchRequest(baseDn, filter, scope, attributes);
    }

    @Override
    public SearchRequest newSearchRequest(Dn baseDn, String filter, SearchScope scope, String ... attributes) {
        return this.modelFactory.newSearchRequest(baseDn, filter, scope, attributes);
    }

    @Override
    public <T extends ResultResponse> T responseOrException(T response) {
        if (ResultCodeEnum.SUCCESS != response.getLdapResult().getResultCode()) {
            throw new LdapRequestUnsuccessfulException(response);
        }
        return response;
    }

    private void returnLdapConnection(LdapConnection connection) {
        if (connection != null) {
            try {
                this.connectionPool.releaseConnection(connection);
            }
            catch (LdapException e) {
                throw new LdapRuntimeException(e);
            }
        }
    }

    @Override
    public <T> List<T> search(String baseDn, FilterBuilder filter, SearchScope scope, EntryMapper<T> entryMapper) {
        return this.search(this.modelFactory.newSearchRequest(baseDn, filter, scope), entryMapper);
    }

    @Override
    public <T> List<T> search(String baseDn, String filter, SearchScope scope, EntryMapper<T> entryMapper) {
        return this.search(this.modelFactory.newSearchRequest(baseDn, filter, scope), entryMapper);
    }

    @Override
    public <T> List<T> search(Dn baseDn, FilterBuilder filter, SearchScope scope, EntryMapper<T> entryMapper) {
        return this.search(this.modelFactory.newSearchRequest(baseDn, filter, scope), entryMapper);
    }

    @Override
    public <T> List<T> search(Dn baseDn, String filter, SearchScope scope, EntryMapper<T> entryMapper) {
        return this.search(this.modelFactory.newSearchRequest(baseDn, filter, scope), entryMapper);
    }

    @Override
    public <T> List<T> search(String baseDn, FilterBuilder filter, SearchScope scope, String[] attributes, EntryMapper<T> entryMapper) {
        return this.search(this.modelFactory.newSearchRequest(baseDn, filter, scope, attributes), entryMapper);
    }

    @Override
    public <T> List<T> search(String baseDn, String filter, SearchScope scope, String[] attributes, EntryMapper<T> entryMapper) {
        return this.search(this.modelFactory.newSearchRequest(baseDn, filter, scope, attributes), entryMapper);
    }

    @Override
    public <T> List<T> search(Dn baseDn, FilterBuilder filter, SearchScope scope, String[] attributes, EntryMapper<T> entryMapper) {
        return this.search(this.modelFactory.newSearchRequest(baseDn, filter, scope, attributes), entryMapper);
    }

    @Override
    public <T> List<T> search(Dn baseDn, String filter, SearchScope scope, String[] attributes, EntryMapper<T> entryMapper) {
        return this.search(this.modelFactory.newSearchRequest(baseDn, filter, scope, attributes), entryMapper);
    }

    @Override
    public <T> List<T> search(SearchRequest searchRequest, EntryMapper<T> entryMapper) {
        ArrayList<T> entries = new ArrayList<T>();
        LdapConnection connection = null;
        try {
            connection = this.connectionPool.getConnection();
            for (Entry entry : new EntryCursorImpl(connection.search(searchRequest))) {
                entries.add(entryMapper.map(entry));
            }
        }
        catch (LdapException e) {
            throw new LdapRuntimeException(e);
        }
        finally {
            this.returnLdapConnection(connection);
        }
        return entries;
    }

    @Override
    public <T> T searchFirst(String baseDn, FilterBuilder filter, SearchScope scope, EntryMapper<T> entryMapper) {
        return this.searchFirst(this.modelFactory.newSearchRequest(baseDn, filter, scope), entryMapper);
    }

    @Override
    public <T> T searchFirst(String baseDn, String filter, SearchScope scope, EntryMapper<T> entryMapper) {
        return this.searchFirst(this.modelFactory.newSearchRequest(baseDn, filter, scope), entryMapper);
    }

    @Override
    public <T> T searchFirst(Dn baseDn, FilterBuilder filter, SearchScope scope, EntryMapper<T> entryMapper) {
        return this.searchFirst(this.modelFactory.newSearchRequest(baseDn, filter, scope), entryMapper);
    }

    @Override
    public <T> T searchFirst(Dn baseDn, String filter, SearchScope scope, EntryMapper<T> entryMapper) {
        return this.searchFirst(this.modelFactory.newSearchRequest(baseDn, filter, scope), entryMapper);
    }

    @Override
    public <T> T searchFirst(String baseDn, FilterBuilder filter, SearchScope scope, String[] attributes, EntryMapper<T> entryMapper) {
        return this.searchFirst(this.modelFactory.newSearchRequest(baseDn, filter, scope, attributes), entryMapper);
    }

    @Override
    public <T> T searchFirst(String baseDn, String filter, SearchScope scope, String[] attributes, EntryMapper<T> entryMapper) {
        return this.searchFirst(this.modelFactory.newSearchRequest(baseDn, filter, scope, attributes), entryMapper);
    }

    @Override
    public <T> T searchFirst(Dn baseDn, FilterBuilder filter, SearchScope scope, String[] attributes, EntryMapper<T> entryMapper) {
        return this.searchFirst(this.modelFactory.newSearchRequest(baseDn, filter, scope, attributes), entryMapper);
    }

    @Override
    public <T> T searchFirst(Dn baseDn, String filter, SearchScope scope, String[] attributes, EntryMapper<T> entryMapper) {
        return this.searchFirst(this.modelFactory.newSearchRequest(baseDn, filter, scope, attributes), entryMapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T searchFirst(SearchRequest searchRequest, EntryMapper<T> entryMapper) {
        long originalSizeLimit = searchRequest.getSizeLimit();
        try {
            searchRequest.setSizeLimit(1L);
            List<T> entries = this.search(searchRequest, entryMapper);
            T t = entries.isEmpty() ? null : (T)entries.get(0);
            return t;
        }
        finally {
            searchRequest.setSizeLimit(originalSizeLimit);
        }
    }

    public void setModelFactory(ModelFactory modelFactory) {
        this.modelFactory = modelFactory;
    }

    public void setPasswordPolicyResponder(PasswordPolicyResponder passwordPolicyResponder) {
        this.passwordPolicyResponder = passwordPolicyResponder;
    }
}

