/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc;

import org.apache.directory.server.kerberos.kdc.KdcContext;
import org.apache.directory.server.kerberos.shared.messages.ErrorMessage;
import org.apache.directory.server.kerberos.shared.messages.KdcReply;
import org.apache.directory.server.kerberos.shared.messages.KerberosMessage;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorReply
implements IoHandlerCommand {
    private static final Logger log = LoggerFactory.getLogger((Class)MonitorReply.class);
    private String contextKey = "context";

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        KdcContext kdcContext = (KdcContext)((Object)session.getAttribute(this.getContextKey()));
        KerberosMessage reply = kdcContext.getReply();
        if (reply instanceof KdcReply) {
            KdcReply success = (KdcReply)message;
            if (log.isDebugEnabled()) {
                log.debug("Responding to authentication request with reply:\n\tclient realm:          " + success.getClientRealm() + "\n\tserver realm:          " + success.getServerRealm() + "\n\tserverPrincipal:       " + success.getServerPrincipal() + "\n\tclientPrincipal:       " + success.getClientPrincipal() + "\n\thostAddresses:         " + success.getClientAddresses() + "\n\tstart time:            " + success.getStartTime() + "\n\tend time:              " + success.getEndTime() + "\n\tauth time:             " + success.getAuthTime() + "\n\trenew till time:       " + success.getRenewTill() + "\n\tmessageType:           " + success.getMessageType() + "\n\tnonce:                 " + success.getNonce() + "\n\tprotocolVersionNumber: " + success.getProtocolVersionNumber());
            }
        } else if (message instanceof ErrorMessage) {
            ErrorMessage error = (ErrorMessage)message;
            if (log.isDebugEnabled()) {
                log.debug("Responding to authentication request with error:\n\tserverPrincipal:       " + error.getServerPrincipal() + "\n\tclientPrincipal:       " + error.getClientPrincipal() + "\n\tserver time:           " + error.getClientTime() + "\n\tclient time:           " + error.getServerTime() + "\n\terror code:            " + error.getErrorCode() + "\n\texplanatory text:      " + error.getExplanatoryText());
            }
        }
        next.execute(session, message);
    }

    public String getContextKey() {
        return this.contextKey;
    }
}

