/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import java.util.List;
import junit.framework.Assert;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.CookieStore;
import org.apache.http.client.protocol.ResponseProcessCookies;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.cookie.BestMatchSpec;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.junit.Before;
import org.junit.Test;

public class TestResponseProcessCookies {
    private CookieOrigin cookieOrigin;
    private CookieSpec cookieSpec;
    private CookieStore cookieStore;

    @Before
    public void setUp() throws Exception {
        this.cookieOrigin = new CookieOrigin("localhost", 80, "/", false);
        this.cookieSpec = new BestMatchSpec();
        this.cookieStore = new BasicCookieStore();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testResponseParameterCheck() throws Exception {
        BasicHttpContext context = new BasicHttpContext();
        ResponseProcessCookies interceptor = new ResponseProcessCookies();
        interceptor.process(null, (HttpContext)context);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testContextParameterCheck() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        ResponseProcessCookies interceptor = new ResponseProcessCookies();
        interceptor.process((HttpResponse)response, null);
    }

    @Test
    public void testParseCookies() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.addHeader("Set-Cookie", "name1=value1");
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.cookie-origin", (Object)this.cookieOrigin);
        context.setAttribute("http.cookie-spec", (Object)this.cookieSpec);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        ResponseProcessCookies interceptor = new ResponseProcessCookies();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        List cookies = this.cookieStore.getCookies();
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((int)1, (int)cookies.size());
        Cookie cookie = (Cookie)cookies.get(0);
        Assert.assertEquals((int)0, (int)cookie.getVersion());
        Assert.assertEquals((String)"name1", (String)cookie.getName());
        Assert.assertEquals((String)"value1", (String)cookie.getValue());
        Assert.assertEquals((String)"localhost", (String)cookie.getDomain());
        Assert.assertEquals((String)"/", (String)cookie.getPath());
    }

    @Test
    public void testNoCookieOrigin() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.addHeader("Set-Cookie", "name1=value1");
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.cookie-origin", null);
        context.setAttribute("http.cookie-spec", (Object)this.cookieSpec);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        ResponseProcessCookies interceptor = new ResponseProcessCookies();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        List cookies = this.cookieStore.getCookies();
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((int)0, (int)cookies.size());
    }

    @Test
    public void testNoCookieSpec() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.addHeader("Set-Cookie", "name1=value1");
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.cookie-origin", (Object)this.cookieOrigin);
        context.setAttribute("http.cookie-spec", null);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        ResponseProcessCookies interceptor = new ResponseProcessCookies();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        List cookies = this.cookieStore.getCookies();
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((int)0, (int)cookies.size());
    }

    @Test
    public void testNoCookieStore() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.addHeader("Set-Cookie", "name1=value1");
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.cookie-origin", (Object)this.cookieOrigin);
        context.setAttribute("http.cookie-spec", (Object)this.cookieSpec);
        context.setAttribute("http.cookie-store", null);
        ResponseProcessCookies interceptor = new ResponseProcessCookies();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        List cookies = this.cookieStore.getCookies();
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((int)0, (int)cookies.size());
    }

    @Test
    public void testSetCookie2OverrideSetCookie() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.addHeader("Set-Cookie", "name1=value1");
        response.addHeader("Set-Cookie2", "name1=value2; Version=1");
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.cookie-origin", (Object)this.cookieOrigin);
        context.setAttribute("http.cookie-spec", (Object)this.cookieSpec);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        ResponseProcessCookies interceptor = new ResponseProcessCookies();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        List cookies = this.cookieStore.getCookies();
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((int)1, (int)cookies.size());
        Cookie cookie = (Cookie)cookies.get(0);
        Assert.assertEquals((int)1, (int)cookie.getVersion());
        Assert.assertEquals((String)"name1", (String)cookie.getName());
        Assert.assertEquals((String)"value2", (String)cookie.getValue());
        Assert.assertEquals((String)"localhost.local", (String)cookie.getDomain());
        Assert.assertEquals((String)"/", (String)cookie.getPath());
    }

    @Test
    public void testInvalidHeader() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.addHeader("Set-Cookie2", "name=value; Version=crap");
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.cookie-origin", (Object)this.cookieOrigin);
        context.setAttribute("http.cookie-spec", (Object)this.cookieSpec);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        ResponseProcessCookies interceptor = new ResponseProcessCookies();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        List cookies = this.cookieStore.getCookies();
        Assert.assertNotNull((Object)cookies);
        Assert.assertTrue((boolean)cookies.isEmpty());
    }

    @Test
    public void testCookieRejected() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.addHeader("Set-Cookie2", "name=value; Domain=www.somedomain.com; Version=1");
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.cookie-origin", (Object)this.cookieOrigin);
        context.setAttribute("http.cookie-spec", (Object)this.cookieSpec);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        ResponseProcessCookies interceptor = new ResponseProcessCookies();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        List cookies = this.cookieStore.getCookies();
        Assert.assertNotNull((Object)cookies);
        Assert.assertTrue((boolean)cookies.isEmpty());
    }
}

