/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.utils;

import java.net.URI;
import org.apache.http.HttpHost;
import org.apache.http.client.utils.URIUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestURIUtils {
    private URI baseURI = URI.create("http://a/b/c/d;p?q");

    @Test
    public void testRewite00() throws Exception {
        URI uri = URI.create("http://thishost/stuff");
        HttpHost target = new HttpHost("thathost", -1);
        Assert.assertEquals((Object)"http://thathost/stuff", (Object)URIUtils.rewriteURI((URI)uri, (HttpHost)target).toString());
    }

    @Test
    public void testRewite01() throws Exception {
        URI uri = URI.create("http://thishost/stuff");
        Assert.assertEquals((Object)"/stuff", (Object)URIUtils.rewriteURI((URI)uri, null).toString());
    }

    @Test
    public void testRewite02() throws Exception {
        URI uri = URI.create("http://thishost//");
        Assert.assertEquals((Object)"/", (Object)URIUtils.rewriteURI((URI)uri, null).toString());
    }

    @Test
    public void testRewite03() throws Exception {
        URI uri = URI.create("http://thishost//stuff///morestuff");
        Assert.assertEquals((Object)"/stuff///morestuff", (Object)URIUtils.rewriteURI((URI)uri, null).toString());
    }

    @Test
    public void testRewite04() throws Exception {
        URI uri = URI.create("http://thishost/stuff#crap");
        HttpHost target = new HttpHost("thathost", -1);
        Assert.assertEquals((Object)"http://thathost/stuff", (Object)URIUtils.rewriteURI((URI)uri, (HttpHost)target, (boolean)true).toString());
    }

    @Test
    public void testRewite05() throws Exception {
        URI uri = URI.create("http://thishost/stuff#crap");
        HttpHost target = new HttpHost("thathost", -1);
        Assert.assertEquals((Object)"http://thathost/stuff#crap", (Object)URIUtils.rewriteURI((URI)uri, (HttpHost)target, (boolean)false).toString());
    }

    @Test
    public void testRewite06() throws Exception {
        URI uri = URI.create("http://thishost//////////////stuff/");
        Assert.assertEquals((Object)"/stuff/", (Object)URIUtils.rewriteURI((URI)uri, null).toString());
    }

    @Test
    public void testResolve00() {
        Assert.assertEquals((Object)"g:h", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g:h").toString());
    }

    @Test
    public void testResolve01() {
        Assert.assertEquals((Object)"http://a/b/c/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g").toString());
    }

    @Test
    public void testResolve02() {
        Assert.assertEquals((Object)"http://a/b/c/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"./g").toString());
    }

    @Test
    public void testResolve03() {
        Assert.assertEquals((Object)"http://a/b/c/g/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g/").toString());
    }

    @Test
    public void testResolve04() {
        Assert.assertEquals((Object)"http://a/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"/g").toString());
    }

    @Test
    public void testResolve05() {
        Assert.assertEquals((Object)"http://g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"//g").toString());
    }

    @Test
    public void testResolve06() {
        Assert.assertEquals((Object)"http://a/b/c/d;p?y", (Object)URIUtils.resolve((URI)this.baseURI, (String)"?y").toString());
    }

    @Test
    public void testResolve06_() {
        Assert.assertEquals((Object)"http://a/b/c/d;p?y#f", (Object)URIUtils.resolve((URI)this.baseURI, (String)"?y#f").toString());
    }

    @Test
    public void testResolve07() {
        Assert.assertEquals((Object)"http://a/b/c/g?y", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g?y").toString());
    }

    @Test
    public void testResolve08() {
        Assert.assertEquals((Object)"http://a/b/c/d;p?q#s", (Object)URIUtils.resolve((URI)this.baseURI, (String)"#s").toString());
    }

    @Test
    public void testResolve09() {
        Assert.assertEquals((Object)"http://a/b/c/g#s", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g#s").toString());
    }

    @Test
    public void testResolve10() {
        Assert.assertEquals((Object)"http://a/b/c/g?y#s", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g?y#s").toString());
    }

    @Test
    public void testResolve11() {
        Assert.assertEquals((Object)"http://a/b/c/;x", (Object)URIUtils.resolve((URI)this.baseURI, (String)";x").toString());
    }

    @Test
    public void testResolve12() {
        Assert.assertEquals((Object)"http://a/b/c/g;x", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g;x").toString());
    }

    @Test
    public void testResolve13() {
        Assert.assertEquals((Object)"http://a/b/c/g;x?y#s", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g;x?y#s").toString());
    }

    @Test
    public void testResolve14() {
        Assert.assertEquals((Object)"http://a/b/c/d;p?q", (Object)URIUtils.resolve((URI)this.baseURI, (String)"").toString());
    }

    @Test
    public void testResolve15() {
        Assert.assertEquals((Object)"http://a/b/c/", (Object)URIUtils.resolve((URI)this.baseURI, (String)".").toString());
    }

    @Test
    public void testResolve16() {
        Assert.assertEquals((Object)"http://a/b/c/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"./").toString());
    }

    @Test
    public void testResolve17() {
        Assert.assertEquals((Object)"http://a/b/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"..").toString());
    }

    @Test
    public void testResolve18() {
        Assert.assertEquals((Object)"http://a/b/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"../").toString());
    }

    @Test
    public void testResolve19() {
        Assert.assertEquals((Object)"http://a/b/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"../g").toString());
    }

    @Test
    public void testResolve20() {
        Assert.assertEquals((Object)"http://a/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"../..").toString());
    }

    @Test
    public void testResolve21() {
        Assert.assertEquals((Object)"http://a/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"../../").toString());
    }

    @Test
    public void testResolve22() {
        Assert.assertEquals((Object)"http://a/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"../../g").toString());
    }

    @Test
    public void testResolveAbnormal23() {
        Assert.assertEquals((Object)"http://a/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"../../../g").toString());
    }

    @Test
    public void testResolveAbnormal24() {
        Assert.assertEquals((Object)"http://a/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"../../../../g").toString());
    }

    @Test
    public void testResolve25() {
        Assert.assertEquals((Object)"http://a/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"/./g").toString());
    }

    @Test
    public void testResolve26() {
        Assert.assertEquals((Object)"http://a/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"/../g").toString());
    }

    @Test
    public void testResolve27() {
        Assert.assertEquals((Object)"http://a/b/c/g.", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g.").toString());
    }

    @Test
    public void testResolve28() {
        Assert.assertEquals((Object)"http://a/b/c/.g", (Object)URIUtils.resolve((URI)this.baseURI, (String)".g").toString());
    }

    @Test
    public void testResolve29() {
        Assert.assertEquals((Object)"http://a/b/c/g..", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g..").toString());
    }

    @Test
    public void testResolve30() {
        Assert.assertEquals((Object)"http://a/b/c/..g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"..g").toString());
    }

    @Test
    public void testResolve31() {
        Assert.assertEquals((Object)"http://a/b/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"./../g").toString());
    }

    @Test
    public void testResolve32() {
        Assert.assertEquals((Object)"http://a/b/c/g/", (Object)URIUtils.resolve((URI)this.baseURI, (String)"./g/.").toString());
    }

    @Test
    public void testResolve33() {
        Assert.assertEquals((Object)"http://a/b/c/g/h", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g/./h").toString());
    }

    @Test
    public void testResolve34() {
        Assert.assertEquals((Object)"http://a/b/c/h", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g/../h").toString());
    }

    @Test
    public void testResolve35() {
        Assert.assertEquals((Object)"http://a/b/c/g;x=1/y", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g;x=1/./y").toString());
    }

    @Test
    public void testResolve36() {
        Assert.assertEquals((Object)"http://a/b/c/y", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g;x=1/../y").toString());
    }

    @Test
    public void testResolve37() {
        Assert.assertEquals((Object)"http://a/b/c/g?y/./x", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g?y/./x").toString());
    }

    @Test
    public void testResolve38() {
        Assert.assertEquals((Object)"http://a/b/c/g?y/../x", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g?y/../x").toString());
    }

    @Test
    public void testResolve39() {
        Assert.assertEquals((Object)"http://a/b/c/g#s/./x", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g#s/./x").toString());
    }

    @Test
    public void testResolve40() {
        Assert.assertEquals((Object)"http://a/b/c/g#s/../x", (Object)URIUtils.resolve((URI)this.baseURI, (String)"g#s/../x").toString());
    }

    @Test
    public void testResolve41() {
        Assert.assertEquals((Object)"http:g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"http:g").toString());
    }

    @Test
    public void testResolve42() {
        Assert.assertEquals((Object)"http://s/a/g", (Object)URIUtils.resolve((URI)this.baseURI, (String)"http://s/a/b/c/./../../g").toString());
    }

    @Test
    public void testResolve43() {
        Assert.assertEquals((Object)"http://s/mid/6", (Object)URIUtils.resolve((URI)this.baseURI, (String)"http://s/mid/content=5/../6").toString());
    }

    @Test
    public void testHTTPCLIENT_911() throws Exception {
        Assert.assertEquals((Object)new HttpHost("localhost"), (Object)URIUtils.extractHost((URI)new URI("http://localhost/abcd")));
        Assert.assertEquals((Object)new HttpHost("localhost"), (Object)URIUtils.extractHost((URI)new URI("http://localhost/abcd%3A")));
        Assert.assertEquals((Object)new HttpHost("local_host"), (Object)URIUtils.extractHost((URI)new URI("http://local_host/abcd")));
        Assert.assertEquals((Object)new HttpHost("local_host"), (Object)URIUtils.extractHost((URI)new URI("http://local_host/abcd%3A")));
        Assert.assertEquals((Object)new HttpHost("localhost", 8), (Object)URIUtils.extractHost((URI)new URI("http://localhost:8/abcd")));
        Assert.assertEquals((Object)new HttpHost("local_host", 8), (Object)URIUtils.extractHost((URI)new URI("http://local_host:8/abcd")));
        Assert.assertEquals((Object)new HttpHost("localhost"), (Object)URIUtils.extractHost((URI)new URI("http://localhost:/abcd")));
        Assert.assertEquals((Object)new HttpHost("local_host"), (Object)URIUtils.extractHost((URI)new URI("http://local_host:/abcd")));
        Assert.assertEquals((Object)new HttpHost("localhost", 8080), (Object)URIUtils.extractHost((URI)new URI("http://user:pass@localhost:8080/abcd")));
        Assert.assertEquals((Object)new HttpHost("local_host", 8080), (Object)URIUtils.extractHost((URI)new URI("http://user:pass@local_host:8080/abcd")));
        Assert.assertEquals((Object)new HttpHost("localhost", 8080), (Object)URIUtils.extractHost((URI)new URI("http://@localhost:8080/abcd")));
        Assert.assertEquals((Object)new HttpHost("local_host", 8080), (Object)URIUtils.extractHost((URI)new URI("http://@local_host:8080/abcd")));
    }
}

