/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import org.apache.http.impl.auth.NTLMEngineImpl;
import org.junit.Test;

public class TestNTLMEngineImpl {
    @Test
    public void testMD4() throws Exception {
        TestNTLMEngineImpl.checkMD4("", "31d6cfe0d16ae931b73c59d7e0c089c0");
        TestNTLMEngineImpl.checkMD4("a", "bde52cb31de33e46245e05fbdbd6fb24");
        TestNTLMEngineImpl.checkMD4("abc", "a448017aaf21d8525fc10ae87aa6729d");
        TestNTLMEngineImpl.checkMD4("message digest", "d9130a8164549fe818874806e1c7014b");
        TestNTLMEngineImpl.checkMD4("abcdefghijklmnopqrstuvwxyz", "d79e1c308aa5bbcdeea8ed63df412da9");
        TestNTLMEngineImpl.checkMD4("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "043f8582f241db351ce627e153e7f0e4");
        TestNTLMEngineImpl.checkMD4("12345678901234567890123456789012345678901234567890123456789012345678901234567890", "e33b4ddc9c38f2199c3e7b164fcc0536");
    }

    static byte checkToNibble(char c) {
        if (c >= 'a' && c <= 'f') {
            return (byte)(c - 97 + 10);
        }
        return (byte)(c - 48);
    }

    static byte[] checkToBytes(String hex) {
        byte[] rval = new byte[hex.length() / 2];
        for (int i = 0; i < rval.length; ++i) {
            rval[i] = (byte)(TestNTLMEngineImpl.checkToNibble(hex.charAt(i * 2)) << 4 | TestNTLMEngineImpl.checkToNibble(hex.charAt(i * 2 + 1)));
        }
        return rval;
    }

    static void checkMD4(String input, String hexOutput) throws Exception {
        NTLMEngineImpl.MD4 md4 = new NTLMEngineImpl.MD4();
        md4.update(input.getBytes("ASCII"));
        byte[] answer = md4.getOutput();
        byte[] correctAnswer = TestNTLMEngineImpl.checkToBytes(hexOutput);
        if (answer.length != correctAnswer.length) {
            throw new Exception("Answer length disagrees for MD4('" + input + "')");
        }
        for (int i = 0; i < answer.length; ++i) {
            if (answer[i] == correctAnswer[i]) continue;
            throw new Exception("Answer value for MD4('" + input + "') disagrees at position " + Integer.toString(i));
        }
    }
}

