/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.environment;

import java.util.Random;
import org.apache.ignite.ml.environment.LearningEnvironment;
import org.apache.ignite.ml.environment.LearningEnvironmentBuilder;
import org.apache.ignite.ml.environment.deploy.DeployingContext;
import org.apache.ignite.ml.environment.logging.MLLogger;
import org.apache.ignite.ml.environment.logging.NoOpLogger;
import org.apache.ignite.ml.environment.parallelism.DefaultParallelismStrategy;
import org.apache.ignite.ml.environment.parallelism.NoParallelismStrategy;
import org.apache.ignite.ml.environment.parallelism.ParallelismStrategy;
import org.apache.ignite.ml.math.functions.IgniteFunction;

public class DefaultLearningEnvironmentBuilder
implements LearningEnvironmentBuilder {
    private static final long serialVersionUID = 8502532880517447662L;
    private static final long INFINITE_TTL = -1L;
    private IgniteFunction<Integer, ParallelismStrategy> parallelismStgy = IgniteFunction.constant(NoParallelismStrategy.INSTANCE);
    private IgniteFunction<Integer, MLLogger.Factory> loggingFactory = IgniteFunction.constant(NoOpLogger.factory());
    private IgniteFunction<Integer, Long> seed = IgniteFunction.constant(new Random().nextLong());
    private IgniteFunction<Integer, Random> rngSupplier = p -> new Random();
    private long dataTtl = -1L;

    DefaultLearningEnvironmentBuilder() {
    }

    @Override
    public LearningEnvironmentBuilder withRNGSeedDependency(IgniteFunction<Integer, Long> seed) {
        this.seed = seed;
        return this;
    }

    @Override
    public LearningEnvironmentBuilder withRandomDependency(IgniteFunction<Integer, Random> rngSupplier) {
        this.rngSupplier = rngSupplier;
        return this;
    }

    @Override
    public LearningEnvironmentBuilder withDataTtl(long dataTtl) {
        this.dataTtl = dataTtl;
        return this;
    }

    @Override
    public DefaultLearningEnvironmentBuilder withParallelismStrategyDependency(IgniteFunction<Integer, ParallelismStrategy> stgy) {
        this.parallelismStgy = stgy;
        return this;
    }

    @Override
    public DefaultLearningEnvironmentBuilder withParallelismStrategyTypeDependency(IgniteFunction<Integer, ParallelismStrategy.Type> stgyType) {
        this.parallelismStgy = part -> DefaultLearningEnvironmentBuilder.strategyByType((ParallelismStrategy.Type)((Object)((Object)stgyType.apply((Integer)part))));
        return this;
    }

    private static ParallelismStrategy strategyByType(ParallelismStrategy.Type stgyType) {
        switch (stgyType) {
            case NO_PARALLELISM: {
                return NoParallelismStrategy.INSTANCE;
            }
            case ON_DEFAULT_POOL: {
                return new DefaultParallelismStrategy();
            }
        }
        throw new IllegalStateException("Wrong type");
    }

    @Override
    public DefaultLearningEnvironmentBuilder withLoggingFactoryDependency(IgniteFunction<Integer, MLLogger.Factory> loggingFactory) {
        this.loggingFactory = loggingFactory;
        return this;
    }

    @Override
    public LearningEnvironment buildForWorker(int part) {
        Random random = (Random)this.rngSupplier.apply(part);
        random.setSeed((Long)this.seed.apply(part));
        return new LearningEnvironmentImpl(part, this.dataTtl, random, (ParallelismStrategy)this.parallelismStgy.apply(part), (MLLogger.Factory)this.loggingFactory.apply(part));
    }

    private class LearningEnvironmentImpl
    implements LearningEnvironment {
        private final ParallelismStrategy parallelismStgy;
        private final MLLogger.Factory loggingFactory;
        private final int part;
        private final long dataTtl;
        private final Random randomNumGen;
        private final DeployingContext deployingCtx = DeployingContext.unitialized();

        private LearningEnvironmentImpl(int part, long dataTtl, Random rng, ParallelismStrategy parallelismStgy, MLLogger.Factory loggingFactory) {
            this.part = part;
            this.dataTtl = dataTtl;
            this.parallelismStgy = parallelismStgy;
            this.loggingFactory = loggingFactory;
            this.randomNumGen = rng;
        }

        @Override
        public ParallelismStrategy parallelismStrategy() {
            return this.parallelismStgy;
        }

        @Override
        public MLLogger logger() {
            return this.loggingFactory.create(this.getClass());
        }

        @Override
        public Random randomNumbersGenerator() {
            return this.randomNumGen;
        }

        @Override
        public <T> MLLogger logger(Class<T> clazz) {
            return this.loggingFactory.create(clazz);
        }

        @Override
        public int partition() {
            return this.part;
        }

        @Override
        public long dataTtl() {
            return this.dataTtl;
        }

        @Override
        public DeployingContext deployingContext() {
            return this.deployingCtx;
        }
    }
}

