/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.inference.builder;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.ignite.ml.inference.Model;
import org.apache.ignite.ml.inference.builder.AsyncModelBuilder;
import org.apache.ignite.ml.inference.parser.ModelParser;
import org.apache.ignite.ml.inference.reader.ModelReader;

public class ThreadedModelBuilder
implements AsyncModelBuilder {
    private final int threads;

    public ThreadedModelBuilder(int threads) {
        this.threads = threads;
    }

    @Override
    public <I extends Serializable, O extends Serializable> Model<I, Future<O>> build(ModelReader reader, ModelParser<I, O, ?> parser) {
        return new ThreadedInfModel(parser.parse(reader.read()), this.threads);
    }

    private static class ThreadedInfModel<I extends Serializable, O extends Serializable>
    implements Model<I, Future<O>> {
        private final Model<I, O> mdl;
        private final ExecutorService threadPool;

        ThreadedInfModel(Model<I, O> mdl, int threads) {
            this.mdl = mdl;
            this.threadPool = Executors.newFixedThreadPool(threads);
        }

        @Override
        public Future<O> predict(I input) {
            return this.threadPool.submit(() -> (Serializable)this.mdl.predict((Serializable)input));
        }

        @Override
        public void close() {
            this.threadPool.shutdown();
        }
    }
}

