/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.knn.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.apache.ignite.ml.knn.utils.PointWithDistance;
import org.apache.ignite.ml.math.distances.DistanceMeasure;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.structures.LabeledVector;

public class PointWithDistanceUtil {
    public static <L> List<LabeledVector<L>> transformToListOrdered(Queue<PointWithDistance<L>> points) {
        ArrayList<LabeledVector<L>> res = new ArrayList<LabeledVector<L>>(points.size());
        while (!points.isEmpty()) {
            PointWithDistance<L> pnt = points.remove();
            res.add(pnt.getPnt());
        }
        return res;
    }

    public static <L> void tryToAddIntoHeap(Queue<PointWithDistance<L>> heap, int k, LabeledVector<L> dataPnt, double distance) {
        if (dataPnt != null) {
            if (heap.size() == k && heap.peek().getDistance() > distance) {
                heap.remove();
            }
            if (heap.size() < k) {
                heap.add(new PointWithDistance<L>(dataPnt, distance));
            }
        }
    }

    public static <L> void tryToAddIntoHeap(Queue<PointWithDistance<L>> heap, int k, Vector pnt, List<LabeledVector<L>> dataPnts, DistanceMeasure distanceMeasure) {
        if (dataPnts != null) {
            for (LabeledVector<L> dataPnt : dataPnts) {
                double distance = distanceMeasure.compute(pnt, (Vector)dataPnt.features());
                PointWithDistanceUtil.tryToAddIntoHeap(heap, k, dataPnt, distance);
            }
        }
    }
}

