/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.functions;

import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.functions.IgniteCurriedBiFunction;
import org.apache.ignite.ml.math.functions.IgniteCurriedTriFunction;
import org.apache.ignite.ml.math.functions.IgniteDoubleFunction;
import org.apache.ignite.ml.math.functions.IgniteFunction;
import org.apache.ignite.ml.math.functions.IgniteSupplier;
import org.apache.ignite.ml.math.functions.IgniteTriFunction;

public final class Functions {
    public static final IgniteDoubleFunction<Double> ABS = Math::abs;
    public static final IgniteDoubleFunction<Double> IDENTITY = a -> a;
    public static final IgniteDoubleFunction<Double> LOG2 = a -> Math.log(a) * 1.4426950408889634;
    public static final IgniteDoubleFunction<Double> NEGATE = a -> -a;
    public static final IgniteDoubleFunction<Double> SIGN = a -> a < 0.0 ? -1.0 : (a > 0.0 ? 1.0 : 0.0);
    public static final IgniteDoubleFunction<Double> SQUARE = a -> a * a;
    public static final IgniteDoubleFunction<Double> SIGMOID = a -> 1.0 / (1.0 + Math.exp(-a));
    public static final IgniteDoubleFunction<Double> INV = a -> 1.0 / a;
    public static final IgniteDoubleFunction<Double> SIGMOIDGRADIENT = a -> a * (1.0 - a);
    public static final IgniteBiFunction<Double, Double, Double> MOD = (a, b) -> a % b;
    public static final IgniteBiFunction<Double, Double, Double> MULT = (a, b) -> a * b;
    public static final IgniteBiFunction<Double, Double, Double> LG = (a, b) -> Math.log(a) / Math.log(b);
    public static final IgniteBiFunction<Double, Double, Double> PLUS = (a, b) -> a + b;
    public static final IgniteBiFunction<Double, Double, Double> MINUS = (a, b) -> a - b;
    public static final IgniteBiFunction<Double, Double, Double> MIN = Math::min;
    public static final IgniteBiFunction<Double, Double, Double> MINUS_ABS = (a, b) -> Math.abs(a - b);
    public static final IgniteBiFunction<Double, Double, Double> MAX_ABS = (a, b) -> Math.max(Math.abs(a), Math.abs(b));
    public static final IgniteBiFunction<Double, Double, Double> MIN_ABS = (a, b) -> Math.min(Math.abs(a), Math.abs(b));
    public static final IgniteBiFunction<Double, Double, Double> PLUS_ABS = (a, b) -> Math.abs(a) + Math.abs(b);
    public static final IgniteBiFunction<Double, Double, Double> MINUS_SQUARED = (a, b) -> (a - b) * (a - b);
    public static final IgniteBiFunction<Double, Double, Double> COMPARE = (a, b) -> a < b ? -1.0 : (a > b ? 1.0 : 0.0);

    public static <T> T MAX_GENERIC(T a, T b, Comparator<T> f) {
        return f.compare(a, b) > 0 ? a : b;
    }

    public static <T> T MIN_GENERIC(T a, T b, Comparator<T> f) {
        return f.compare(a, b) < 0 ? a : b;
    }

    public static <A, B extends Comparable<B>> IgniteBiTuple<Integer, A> argmin(List<A> args, IgniteFunction<A, B> f) {
        Object res = null;
        Comparable fRes = null;
        if (!args.isEmpty()) {
            res = args.iterator().next();
            fRes = (Comparable)f.apply(res);
        }
        int resInd = 0;
        int i = 0;
        for (A arg : args) {
            Comparable curRes = (Comparable)f.apply(arg);
            if (fRes.compareTo(curRes) > 0) {
                res = arg;
                resInd = i;
                fRes = curRes;
            }
            ++i;
        }
        return new IgniteBiTuple((Object)resInd, res);
    }

    public static IgniteDoubleFunction<Double> plus(double b) {
        return a -> a + b;
    }

    public static IgniteDoubleFunction<Double> mult(double b) {
        return a -> a * b;
    }

    public static IgniteDoubleFunction<Double> div(double b) {
        return Functions.mult(1.0 / b);
    }

    public static IgniteBiFunction<Double, Double, Double> plusMult(double constant) {
        return (a, b) -> a + b * constant;
    }

    public static IgniteBiFunction<Double, Double, Double> minusMult(double constant) {
        return (a, b) -> a - b * constant;
    }

    public static IgniteDoubleFunction<Double> constant(Double c) {
        return a -> c;
    }

    public static IgniteDoubleFunction<Double> pow(double b) {
        return a -> b == 2.0 ? a * a : Math.pow(a, b);
    }

    public static <A, B, C> IgniteCurriedBiFunction<A, B, C> curry(BiFunction<A, B, C> f) {
        return a -> b -> f.apply(a, b);
    }

    public static <A, B, C> IgniteCurriedBiFunction<A, B, C> curry(IgniteBiFunction<A, B, C> f) {
        return a -> b -> f.apply(a, b);
    }

    public static <A, B, C, D> IgniteCurriedTriFunction<A, B, C, D> curry(IgniteTriFunction<A, B, C, D> f) {
        return a -> b -> c -> f.apply(a, b, c);
    }

    public static <A, B> IgniteFunction<A, IgniteSupplier<B>> outputSupplier(IgniteFunction<A, B> f) {
        return a -> {
            Object res = f.apply(a);
            return () -> res;
        };
    }

    public static <A, B, C> IgniteBiFunction<A, B, IgniteSupplier<C>> outputSupplier(IgniteBiFunction<A, B, C> f) {
        return (a, b) -> {
            Object res = f.apply(a, b);
            return () -> res;
        };
    }
}

