/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.primitives.matrix.storage;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.apache.ignite.ml.math.functions.IgniteIntIntToIntBiFunction;
import org.apache.ignite.ml.math.primitives.matrix.MatrixStorage;
import org.apache.ignite.ml.math.util.MatrixUtil;

public class DenseMatrixStorage
implements MatrixStorage {
    private double[] data;
    private int rows;
    private int cols;
    private int stoMode;
    private IgniteIntIntToIntBiFunction idxMapper;

    public DenseMatrixStorage() {
    }

    public DenseMatrixStorage(int rows, int cols) {
        this(rows, cols, 2001);
    }

    public DenseMatrixStorage(int rows, int cols, int stoMode) {
        assert (rows > 0);
        assert (cols > 0);
        this.data = new double[rows * cols];
        this.rows = rows;
        this.cols = cols;
        this.idxMapper = this.indexMapper(stoMode);
        this.stoMode = stoMode;
    }

    public DenseMatrixStorage(double[][] data, int stoMode) {
        this(MatrixUtil.flatten(data, stoMode), data.length, stoMode);
    }

    public DenseMatrixStorage(double[][] data) {
        this(MatrixUtil.flatten(data, 2001), data.length);
    }

    public DenseMatrixStorage(double[] data, int rows, int stoMode) {
        assert (data != null);
        assert (data.length % rows == 0);
        this.data = data;
        this.rows = rows;
        this.cols = data.length / rows;
        this.idxMapper = this.indexMapper(stoMode);
        this.stoMode = stoMode;
        assert (rows > 0);
        assert (this.cols > 0);
    }

    public DenseMatrixStorage(double[] data, int rows) {
        this(data, rows, 2001);
    }

    @Override
    public double get(int x, int y) {
        return this.data[this.idxMapper.apply(x, y)];
    }

    @Override
    public boolean isDense() {
        return true;
    }

    @Override
    public void set(int x, int y, double v) {
        this.data[this.idxMapper.apply((int)x, (int)y)] = v;
    }

    @Override
    public int columnSize() {
        return this.cols;
    }

    @Override
    public int rowSize() {
        return this.rows;
    }

    @Override
    public boolean isArrayBased() {
        return true;
    }

    @Override
    public double[] data() {
        return this.data;
    }

    @Override
    public int storageMode() {
        return this.stoMode;
    }

    private IgniteIntIntToIntBiFunction indexMapper(int stoMode) {
        return stoMode == 2002 ? (r, c) -> r * this.cols + c : (r, c) -> c * this.rows + r;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.rows);
        out.writeInt(this.cols);
        out.writeInt(this.stoMode);
        out.writeObject(this.data);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rows = in.readInt();
        this.cols = in.readInt();
        this.stoMode = in.readInt();
        this.idxMapper = this.indexMapper(this.stoMode);
        this.data = (double[])in.readObject();
    }

    @Override
    public int accessMode() {
        return this.stoMode;
    }

    public int hashCode() {
        int res = 1;
        res += res * 37 + this.rows;
        res += res * 37 + this.cols;
        res += res * 37 + this.stoMode;
        res += res * 37 + Arrays.hashCode(this.data);
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DenseMatrixStorage that = (DenseMatrixStorage)o;
        return this.stoMode == that.stoMode && Arrays.equals(this.data, that.data);
    }
}

