/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.preprocessing.minmaxscaling;

import java.util.Collections;
import java.util.List;
import org.apache.ignite.ml.environment.deploy.DeployableObject;
import org.apache.ignite.ml.preprocessing.Preprocessor;
import org.apache.ignite.ml.structures.LabeledVector;

public final class MinMaxScalerPreprocessor<K, V>
implements Preprocessor<K, V>,
DeployableObject {
    private static final long serialVersionUID = 6997800576392623469L;
    private final double[] min;
    private final double[] max;
    private final Preprocessor<K, V> basePreprocessor;

    public MinMaxScalerPreprocessor(double[] min, double[] max, Preprocessor<K, V> basePreprocessor) {
        this.min = min;
        this.max = max;
        this.basePreprocessor = basePreprocessor;
    }

    @Override
    public LabeledVector apply(K k, V v) {
        LabeledVector res = (LabeledVector)this.basePreprocessor.apply(k, v);
        assert (res.size() == this.min.length);
        assert (res.size() == this.max.length);
        for (int i = 0; i < res.size(); ++i) {
            double denom;
            double num = res.get(i) - this.min[i];
            double scaled = num / (denom = this.max[i] - this.min[i]);
            if (Double.isNaN(scaled)) {
                res.set(i, num);
                continue;
            }
            res.set(i, scaled);
        }
        return res;
    }

    public double[] getMin() {
        return this.min;
    }

    public double[] getMax() {
        return this.max;
    }

    @Override
    public List<Object> getDependencies() {
        return Collections.singletonList(this.basePreprocessor);
    }
}

