/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.cv;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CrossValidationResult
implements Serializable {
    private final Lock lock = new ReentrantLock();
    private ConcurrentHashMap<String, Double> bestHyperParams;
    private double[] bestScore;
    private final Map<ConcurrentHashMap<String, Double>, double[]> scoringBoard = new ConcurrentHashMap<ConcurrentHashMap<String, Double>, double[]>();

    public double getBest(String hyperParamName) {
        return this.bestHyperParams.get(hyperParamName);
    }

    public double[] getBestScore() {
        double[] bestScoreCopy;
        this.lock.lock();
        try {
            bestScoreCopy = (double[])this.bestScore.clone();
        }
        finally {
            this.lock.unlock();
        }
        return bestScoreCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addScores(double[] locScores, Map<String, Double> paramMap) {
        this.lock.lock();
        try {
            double locAvgScore = Arrays.stream(locScores).average().orElse(Double.MIN_VALUE);
            if (locAvgScore >= this.getBestAvgScore()) {
                this.bestScore = (double[])locScores.clone();
                this.bestHyperParams = new ConcurrentHashMap<String, Double>(paramMap);
            }
            this.scoringBoard.put(new ConcurrentHashMap<String, Double>(paramMap), locScores);
        }
        finally {
            this.lock.unlock();
        }
    }

    public double getBestAvgScore() {
        this.lock.lock();
        try {
            if (this.bestScore == null) {
                double d = Double.MIN_VALUE;
                return d;
            }
            double d = Arrays.stream(this.bestScore).average().orElse(Double.MIN_VALUE);
            return d;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Map<Map<String, Double>, double[]> getScoringBoard() {
        HashMap<Map<String, Double>, double[]> result;
        this.lock.lock();
        try {
            result = new HashMap<Map<String, Double>, double[]>();
            this.scoringBoard.forEach((hyperParams, scores) -> result.put(new HashMap(hyperParams), (double[])scores.clone()));
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    public Map<Map<String, Double>, Double> getScoringBoardWithAverages() {
        HashMap<Map<String, Double>, Double> result;
        this.lock.lock();
        try {
            result = new HashMap<Map<String, Double>, Double>();
            this.scoringBoard.forEach((hyperParams, scores) -> result.put(new HashMap(hyperParams), Arrays.stream(scores).average().orElse(Double.MIN_VALUE)));
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    public Map<String, Double> getBestHyperParams() {
        HashMap<String, Double> result;
        this.lock.lock();
        try {
            result = new HashMap<String, Double>(this.bestHyperParams);
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    public String toString() {
        return "CrossValidationResult{bestHyperParams=" + this.getBestHyperParams() + ", bestScore=" + Arrays.toString(this.getBestScore()) + '}';
    }
}

