/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.paramgrid;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.ml.math.functions.IgniteDoubleConsumer;
import org.apache.ignite.ml.selection.paramgrid.BruteForceStrategy;
import org.apache.ignite.ml.selection.paramgrid.HyperParameterTuningStrategy;

public class ParamGrid
implements Serializable {
    private Map<Integer, Double[]> paramValuesByParamIdx = new HashMap<Integer, Double[]>();
    private Map<Integer, IgniteDoubleConsumer> settersByParamIdx = new HashMap<Integer, IgniteDoubleConsumer>();
    private Map<Integer, String> paramNamesByParamIdx = new HashMap<Integer, String>();
    private int paramCntr;
    private HyperParameterTuningStrategy paramSearchStgy = new BruteForceStrategy();

    public Map<Integer, Double[]> getParamValuesByParamIdx() {
        return Collections.unmodifiableMap(this.paramValuesByParamIdx);
    }

    public ParamGrid addHyperParam(String paramName, IgniteDoubleConsumer setter, Double[] params) {
        this.paramValuesByParamIdx.put(this.paramCntr, params);
        this.paramNamesByParamIdx.put(this.paramCntr, paramName);
        this.settersByParamIdx.put(this.paramCntr, setter);
        ++this.paramCntr;
        return this;
    }

    public ParamGrid withParameterSearchStrategy(HyperParameterTuningStrategy paramSearchStgy) {
        this.paramSearchStgy = paramSearchStgy;
        return this;
    }

    public HyperParameterTuningStrategy getHyperParameterTuningStrategy() {
        return this.paramSearchStgy;
    }

    public IgniteDoubleConsumer getSetterByIndex(int idx) {
        return this.settersByParamIdx.get(idx);
    }

    public String getParamNameByIndex(int idx) {
        return this.paramNamesByParamIdx.get(idx);
    }

    public List<Double[]> getParamRawData() {
        ArrayList<Double[]> res = new ArrayList<Double[]>();
        this.paramValuesByParamIdx.forEach(res::add);
        return res;
    }
}

