/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.scoring.metric.classification;

import java.io.Serializable;
import org.apache.ignite.ml.selection.scoring.evaluator.aggregator.BinaryClassificationPointwiseMetricStatsAggregator;
import org.apache.ignite.ml.selection.scoring.metric.MetricName;
import org.apache.ignite.ml.selection.scoring.metric.classification.BinaryClassificationMetric;

public class BalancedAccuracy<L extends Serializable>
extends BinaryClassificationMetric<L> {
    private static final long serialVersionUID = 91677523635381939L;
    private Double val = Double.NaN;

    public BalancedAccuracy() {
    }

    public BalancedAccuracy(L truthLb, L falseLb) {
        super(truthLb, falseLb);
    }

    public BalancedAccuracy<L> initBy(BinaryClassificationPointwiseMetricStatsAggregator<L> aggr) {
        int n = aggr.getTrueNegative() + aggr.getFalsePositive();
        int p = aggr.getTruePositive() + aggr.getFalseNegative();
        this.val = n == 0 && p == 0 ? 1.0 : ((double)aggr.getTruePositive() / (double)p + (double)aggr.getTrueNegative() / (double)n) / 2.0;
        return this;
    }

    @Override
    public double value() {
        return this.val;
    }

    @Override
    public MetricName name() {
        return MetricName.BALANCED_ACCURACY;
    }
}

