/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.structures.partition;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.ignite.ml.dataset.PartitionDataBuilder;
import org.apache.ignite.ml.dataset.UpstreamEntry;
import org.apache.ignite.ml.environment.LearningEnvironment;
import org.apache.ignite.ml.preprocessing.Preprocessor;
import org.apache.ignite.ml.structures.LabeledVector;
import org.apache.ignite.ml.structures.partition.LabelPartitionDataOnHeap;

public class LabelPartitionDataBuilderOnHeap<K, V, C extends Serializable>
implements PartitionDataBuilder<K, V, C, LabelPartitionDataOnHeap> {
    private static final long serialVersionUID = -7820760153954269227L;
    private final Preprocessor<K, V> preprocessor;

    public LabelPartitionDataBuilderOnHeap(Preprocessor<K, V> preprocessor) {
        this.preprocessor = preprocessor;
    }

    @Override
    public LabelPartitionDataOnHeap build(LearningEnvironment env, Iterator<UpstreamEntry<K, V>> upstreamData, long upstreamDataSize, C ctx) {
        double[] y = new double[Math.toIntExact(upstreamDataSize)];
        int ptr = 0;
        while (upstreamData.hasNext()) {
            UpstreamEntry<K, V> entry = upstreamData.next();
            y[ptr] = (Double)((LabeledVector)this.preprocessor.apply(entry.getKey(), entry.getValue())).label();
            ++ptr;
        }
        return new LabelPartitionDataOnHeap(y);
    }
}

