/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.tree.randomforest;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.ml.composition.ModelsComposition;
import org.apache.ignite.ml.composition.predictionsaggregator.MeanValuePredictionsAggregator;
import org.apache.ignite.ml.composition.predictionsaggregator.PredictionsAggregator;
import org.apache.ignite.ml.inference.json.JSONModelMixIn;
import org.apache.ignite.ml.inference.json.JSONWritable;
import org.apache.ignite.ml.inference.json.JacksonHelper;
import org.apache.ignite.ml.tree.randomforest.data.RandomForestTreeModel;

public class RandomForestModel
extends ModelsComposition<RandomForestTreeModel>
implements JSONWritable {
    private static final long serialVersionUID = 3476345240155508004L;

    public RandomForestModel() {
        super(new ArrayList(), new MeanValuePredictionsAggregator());
    }

    public RandomForestModel(List<RandomForestTreeModel> oldModels, PredictionsAggregator predictionsAggregator) {
        super(oldModels, predictionsAggregator);
    }

    @Override
    public PredictionsAggregator getPredictionsAggregator() {
        return this.predictionsAggregator;
    }

    @Override
    public List<RandomForestTreeModel> getModels() {
        return this.models;
    }

    @Override
    public void toJSON(Path path) {
        ObjectMapper mapper = new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.addMixIn(RandomForestModel.class, JSONModelMixIn.class);
        ObjectWriter writer = mapper.writerFor(RandomForestModel.class).withAttribute((Object)"formatVersion", (Object)"1").withAttribute((Object)"timestamp", (Object)System.currentTimeMillis()).withAttribute((Object)"uid", (Object)("dt_" + UUID.randomUUID().toString())).withAttribute((Object)"modelClass", (Object)RandomForestModel.class.getSimpleName());
        try {
            File file = new File(path.toAbsolutePath().toString());
            writer.writeValue(file, (Object)this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static RandomForestModel fromJSON(Path path) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            JacksonHelper.readAndValidateBasicJsonModelProperties(path, mapper, RandomForestModel.class.getSimpleName());
            RandomForestModel mdl = (RandomForestModel)mapper.readValue(new File(path.toAbsolutePath().toString()), RandomForestModel.class);
            return mdl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

