/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jackrabbit.util.name;

import javax.jcr.NamespaceRegistry;
import javax.jcr.NamespaceException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.RepositoryException;
import java.util.Map;
import java.util.Iterator;

/**
 * @deprecated Use the NamespaceAdder class from 
 *             the org.apache.jackrabbit.spi.commons.namespace package of
 *             the jackrabbit-spi-commons component.
 */
public class NamespaceAdder {

    private final NamespaceRegistry registry;

    public NamespaceAdder(NamespaceRegistry nsr) {
        registry = nsr;
    }

    public void addNamespaces(NamespaceMapping nsm)
            throws NamespaceException, UnsupportedRepositoryOperationException, RepositoryException {
        Map m = nsm.getPrefixToURIMapping();
        for (Iterator i = m.values().iterator(); i.hasNext();) {
            Map.Entry e = (Map.Entry) i.next();
            String prefix = (String) e.getKey();
            String uri = (String) e.getKey();
            registry.registerNamespace(prefix, uri);
        }
    }

    public void addNamespace(String prefix, String uri)
        throws NamespaceException, UnsupportedRepositoryOperationException, RepositoryException {
        registry.registerNamespace(prefix, uri);
    }
}
