/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.LockItem;
import com.amazonaws.services.dynamodbv2.LockItemFactory;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;

final class LockItemPaginatedScanIterator
implements Iterator<LockItem> {
    private final AmazonDynamoDB dynamoDB;
    private final ScanRequest scanRequest;
    private final LockItemFactory lockItemFactory;
    private List<LockItem> currentPageResults = Collections.emptyList();
    private int currentPageResultsIndex = 0;
    private ScanResult scanResult = null;

    LockItemPaginatedScanIterator(AmazonDynamoDB dynamoDB, ScanRequest scanRequest, LockItemFactory lockItemFactory) {
        this.dynamoDB = Objects.requireNonNull(dynamoDB, "dynamoDB must not be null");
        this.scanRequest = Objects.requireNonNull(scanRequest, "scanRequest must not be null");
        this.lockItemFactory = Objects.requireNonNull(lockItemFactory, "lockItemFactory must not be null");
    }

    @Override
    public boolean hasNext() {
        while (this.currentPageResultsIndex == this.currentPageResults.size() && this.hasAnotherPageToLoad()) {
            this.loadNextPageIntoResults();
        }
        return this.currentPageResultsIndex < this.currentPageResults.size();
    }

    @Override
    public LockItem next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        LockItem next = this.currentPageResults.get(this.currentPageResultsIndex);
        ++this.currentPageResultsIndex;
        return next;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This iterator is immutable.");
    }

    private boolean hasAnotherPageToLoad() {
        if (!this.hasLoadedFirstPage()) {
            return true;
        }
        return this.scanResult.getLastEvaluatedKey() != null;
    }

    private boolean hasLoadedFirstPage() {
        return this.scanResult != null;
    }

    private void loadNextPageIntoResults() {
        this.scanResult = this.dynamoDB.scan(this.scanRequest);
        this.currentPageResults = this.scanResult.getItems().stream().map(this.lockItemFactory::create).collect(Collectors.toList());
        this.currentPageResultsIndex = 0;
        this.scanRequest.withExclusiveStartKey(this.scanResult.getLastEvaluatedKey());
    }
}

