/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.aws;

import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.util.TimingInfo;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.segment.aws.Configuration;
import org.apache.jackrabbit.oak.segment.aws.DynamoDBClient;
import org.apache.jackrabbit.oak.segment.aws.DynamoDBProvisioningData;
import org.apache.jackrabbit.oak.segment.aws.S3Directory;
import org.apache.jackrabbit.oak.segment.spi.monitor.RemoteStoreMonitor;

public final class AwsContext {
    public final S3Directory directory;
    public final DynamoDBClient dynamoDBClient;
    private final String path;
    private RemoteStoreMonitor monitor;

    private AwsContext(AmazonS3 s3, String bucketName, String rootDirectory, AmazonDynamoDB ddb, String journalTableName, String lockTableName) {
        this(s3, bucketName, rootDirectory, ddb, journalTableName, lockTableName, DynamoDBProvisioningData.DEFAULT);
    }

    private AwsContext(AmazonS3 s3, String bucketName, String rootDirectory, AmazonDynamoDB ddb, String journalTableName, String lockTableName, DynamoDBProvisioningData provisioningData) {
        this.directory = new S3Directory(s3, bucketName, rootDirectory);
        this.dynamoDBClient = new DynamoDBClient(ddb, journalTableName, lockTableName, provisioningData);
        this.path = bucketName + "/" + rootDirectory + "/";
    }

    private AwsContext(Configuration configuration) {
        String region;
        AmazonS3ClientBuilder s3ClientBuilder = AmazonS3ClientBuilder.standard();
        AmazonDynamoDBClientBuilder dynamoDBClientBuilder = AmazonDynamoDBClientBuilder.standard();
        if (!AwsContext.isEmpty(configuration.accessKey())) {
            AWSCredentials credentials = AwsContext.isEmpty(configuration.sessionToken()) ? new BasicAWSCredentials(configuration.accessKey(), configuration.secretKey()) : new BasicSessionCredentials(configuration.accessKey(), configuration.secretKey(), configuration.sessionToken());
            AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider(credentials);
            s3ClientBuilder = (AmazonS3ClientBuilder)s3ClientBuilder.withCredentials(credentialsProvider);
            dynamoDBClientBuilder = (AmazonDynamoDBClientBuilder)dynamoDBClientBuilder.withCredentials(credentialsProvider);
        }
        if (!AwsContext.isEmpty(region = configuration.region())) {
            s3ClientBuilder = (AmazonS3ClientBuilder)s3ClientBuilder.withRegion(region);
            dynamoDBClientBuilder = (AmazonDynamoDBClientBuilder)dynamoDBClientBuilder.withRegion(region);
        }
        RequestHandler2 handler = new RequestHandler2(){

            @Override
            public void afterError(Request<?> request, Response<?> response, Exception e) {
                this.process(request, response, e);
            }

            @Override
            public void afterResponse(Request<?> request, Response<?> response) {
                this.process(request, response, null);
            }

            private void process(Request<?> request, Response<?> response, Exception e) {
                if (AwsContext.this.monitor != null) {
                    TimingInfo timing = request.getAWSRequestMetrics().getTimingInfo();
                    if (timing.isEndTimeKnown()) {
                        long requestDuration = timing.getEndTimeNano() - timing.getStartTimeNano();
                        AwsContext.this.monitor.requestDuration(requestDuration, TimeUnit.NANOSECONDS);
                    }
                    if (e == null) {
                        AwsContext.this.monitor.requestCount();
                    } else {
                        AwsContext.this.monitor.requestError();
                    }
                }
            }
        };
        s3ClientBuilder = (AmazonS3ClientBuilder)s3ClientBuilder.withRequestHandlers(handler);
        dynamoDBClientBuilder = (AmazonDynamoDBClientBuilder)dynamoDBClientBuilder.withRequestHandlers(handler);
        this.directory = new S3Directory((AmazonS3)s3ClientBuilder.build(), configuration.bucketName(), configuration.rootDirectory());
        this.dynamoDBClient = new DynamoDBClient((AmazonDynamoDB)dynamoDBClientBuilder.build(), configuration.journalTableName(), configuration.lockTableName(), DynamoDBProvisioningData.DEFAULT);
        this.path = configuration.bucketName() + "/" + configuration.rootDirectory() + "/";
    }

    public static AwsContext create(Configuration configuration) throws IOException {
        AwsContext awsContext = new AwsContext(configuration);
        awsContext.directory.ensureBucket();
        awsContext.dynamoDBClient.ensureTables();
        return awsContext;
    }

    public static AwsContext create(AmazonS3 s3, String bucketName, String rootDirectory, AmazonDynamoDB ddb, String journalTableName, String lockTableName) throws IOException {
        AwsContext awsContext = new AwsContext(s3, bucketName, rootDirectory, ddb, journalTableName, lockTableName);
        awsContext.directory.ensureBucket();
        awsContext.dynamoDBClient.ensureTables();
        return awsContext;
    }

    public static AwsContext create(AmazonS3 s3, String bucketName, String rootDirectory, AmazonDynamoDB ddb, String journalTableName, String lockTableName, DynamoDBProvisioningData provisioningData) throws IOException {
        AwsContext awsContext = new AwsContext(s3, bucketName, rootDirectory, ddb, journalTableName, lockTableName, provisioningData);
        awsContext.directory.ensureBucket();
        awsContext.dynamoDBClient.ensureTables();
        return awsContext;
    }

    public void setRemoteStoreMonitor(RemoteStoreMonitor monitor) {
        this.monitor = monitor;
    }

    public String getPath(String fileName) {
        return this.path + fileName;
    }

    public String getConfig() {
        return "aws:" + this.directory.getConfig() + ';' + this.dynamoDBClient.getConfig();
    }

    private static boolean isEmpty(String input) {
        return input == null || input.isEmpty();
    }
}

