/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.inject.Singleton;
import org.jclouds.atmos.options.ListOptions;
import org.jclouds.blobstore.options.ListContainerOptions;

@Singleton
public class BlobStoreListOptionsToListOptions
implements Function<ListContainerOptions, ListOptions> {
    public ListOptions apply(ListContainerOptions from) {
        Preconditions.checkNotNull((Object)from, (Object)"set options to instance NONE instead of passing null");
        ListOptions httpOptions = new ListOptions();
        if (from.getMarker() != null) {
            httpOptions.token(from.getMarker());
        }
        if (from.getMaxResults() != null) {
            httpOptions.limit(from.getMaxResults());
        }
        if (from.isDetailed()) {
            httpOptions.includeMeta();
        }
        return httpOptions;
    }
}

