/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v3.features;

import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.keystone.v3.domain.Group;
import org.jclouds.openstack.keystone.v3.domain.Project;
import org.jclouds.openstack.keystone.v3.domain.User;
import org.jclouds.openstack.v2_0.services.Identity;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.PATCH;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.WrapWith;

@Consumes(value={"application/json"})
@RequestFilters(value={AuthenticateRequest.class})
@Endpoint(value=Identity.class)
@Path(value="/users")
public interface UserApi {
    @Named(value="users:list")
    @GET
    @SelectJson(value={"users"})
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<User> list();

    @Named(value="users:get")
    @GET
    @Path(value="/{id}")
    @SelectJson(value={"user"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public User get(@PathParam(value="id") String var1);

    @Named(value="users:create")
    @POST
    @SelectJson(value={"user"})
    @WrapWith(value="user")
    public User create(@PayloadParam(value="name") String var1, @Nullable @PayloadParam(value="password") String var2, @Nullable @PayloadParam(value="enabled") Boolean var3, @Nullable @PayloadParam(value="domain_id") String var4, @Nullable @PayloadParam(value="default_project_id") String var5);

    @Named(value="users:update")
    @PATCH
    @Path(value="/{id}")
    @SelectJson(value={"user"})
    @WrapWith(value="user")
    public User update(@PathParam(value="id") String var1, @PayloadParam(value="name") String var2, @Nullable @PayloadParam(value="password") String var3, @Nullable @PayloadParam(value="enabled") Boolean var4, @Nullable @PayloadParam(value="domain_id") String var5, @Nullable @PayloadParam(value="default_project_id") String var6);

    @Named(value="users:delete")
    @DELETE
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="id") String var1);

    @Named(value="users:groups")
    @GET
    @Path(value="/{id}/groups")
    @SelectJson(value={"groups"})
    public List<Group> listGroups(@PathParam(value="id") String var1);

    @Named(value="users:projects")
    @GET
    @Path(value="/{id}/projects")
    @SelectJson(value={"projects"})
    public List<Project> listProjects(@PathParam(value="id") String var1);

    @Named(value="users:password")
    @POST
    @Path(value="/{id}/password")
    @WrapWith(value="user")
    public void changePassword(@PathParam(value="id") String var1, @PayloadParam(value="original_password") String var2, @PayloadParam(value="password") String var3);
}

