/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.blobstore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.functions.BlobName;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.internal.BaseBlobStore;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.strategy.internal.FetchBlobMetadata;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.openstack.swift.CommonSwiftClient;
import org.jclouds.openstack.swift.blobstore.functions.BlobStoreListContainerOptionsToListContainerOptions;
import org.jclouds.openstack.swift.blobstore.functions.BlobToObject;
import org.jclouds.openstack.swift.blobstore.functions.ContainerToResourceList;
import org.jclouds.openstack.swift.blobstore.functions.ContainerToResourceMetadata;
import org.jclouds.openstack.swift.blobstore.functions.ObjectToBlob;
import org.jclouds.openstack.swift.blobstore.functions.ObjectToBlobMetadata;
import org.jclouds.openstack.swift.blobstore.strategy.internal.MultipartUploadStrategy;
import org.jclouds.openstack.swift.domain.ContainerMetadata;
import org.jclouds.openstack.swift.domain.MutableObjectInfoWithMetadata;
import org.jclouds.openstack.swift.domain.ObjectInfo;
import org.jclouds.openstack.swift.options.ListContainerOptions;

@Singleton
public class SwiftBlobStore
extends BaseBlobStore {
    private final ListeningExecutorService userExecutor;
    private final CommonSwiftClient sync;
    private final ContainerToResourceMetadata container2ResourceMd;
    private final BlobStoreListContainerOptionsToListContainerOptions container2ContainerListOptions;
    private final ContainerToResourceList container2ResourceList;
    private final ObjectToBlob object2Blob;
    private final BlobToObject blob2Object;
    private final ObjectToBlobMetadata object2BlobMd;
    private final BlobToHttpGetOptions blob2ObjectGetOptions;
    private final Provider<FetchBlobMetadata> fetchBlobMetadataProvider;
    private final Provider<MultipartUploadStrategy> multipartUploadStrategy;
    private static final BlobName blobName = new BlobName();

    @Inject
    protected SwiftBlobStore(@Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, BlobStoreContext context, BlobUtils blobUtils, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations, CommonSwiftClient sync, ContainerToResourceMetadata container2ResourceMd, BlobStoreListContainerOptionsToListContainerOptions container2ContainerListOptions, ContainerToResourceList container2ResourceList, ObjectToBlob object2Blob, BlobToObject blob2Object, ObjectToBlobMetadata object2BlobMd, BlobToHttpGetOptions blob2ObjectGetOptions, Provider<FetchBlobMetadata> fetchBlobMetadataProvider, Provider<MultipartUploadStrategy> multipartUploadStrategy) {
        super(context, blobUtils, defaultLocation, locations);
        this.userExecutor = userExecutor;
        this.sync = sync;
        this.container2ResourceMd = container2ResourceMd;
        this.container2ContainerListOptions = container2ContainerListOptions;
        this.container2ResourceList = container2ResourceList;
        this.object2Blob = object2Blob;
        this.blob2Object = blob2Object;
        this.object2BlobMd = object2BlobMd;
        this.blob2ObjectGetOptions = blob2ObjectGetOptions;
        this.fetchBlobMetadataProvider = (Provider)Preconditions.checkNotNull(fetchBlobMetadataProvider, (Object)"fetchBlobMetadataProvider");
        this.multipartUploadStrategy = multipartUploadStrategy;
    }

    public PageSet<? extends StorageMetadata> list() {
        return new Function<Set<ContainerMetadata>, PageSet<? extends StorageMetadata>>(){

            public PageSet<? extends StorageMetadata> apply(Set<ContainerMetadata> from) {
                return new PageSetImpl(Iterables.transform(from, (Function)SwiftBlobStore.this.container2ResourceMd), null);
            }
        }.apply(this.sync.listContainers(new ListContainerOptions[0]));
    }

    public boolean containerExists(String container) {
        return this.sync.containerExists(container);
    }

    public boolean createContainerInLocation(Location location, String container) {
        return this.sync.createContainer(container);
    }

    public PageSet<? extends StorageMetadata> list(String container, org.jclouds.blobstore.options.ListContainerOptions options) {
        ListContainerOptions httpOptions = this.container2ContainerListOptions.apply(options);
        PageSet list = this.container2ResourceList.apply(this.sync.listObjects(container, httpOptions));
        return options.isDetailed() ? ((FetchBlobMetadata)this.fetchBlobMetadataProvider.get()).setContainerName(container).apply(list) : list;
    }

    public boolean blobExists(String container, String key) {
        return this.sync.objectExists(container, key);
    }

    public BlobMetadata blobMetadata(String container, String key) {
        return this.object2BlobMd.apply(this.sync.getObjectInfo(container, key));
    }

    public Blob getBlob(String container, String key, GetOptions optionsList) {
        org.jclouds.http.options.GetOptions httpOptions = this.blob2ObjectGetOptions.apply(optionsList);
        return this.object2Blob.apply(this.sync.getObject(container, key, httpOptions));
    }

    public String putBlob(String container, Blob blob) {
        this.createParentIfNeededAsync(container, blob);
        return this.sync.putObject(container, this.blob2Object.apply(blob));
    }

    private void createParentIfNeededAsync(final String containerName, Blob blob) {
        Preconditions.checkNotNull((Object)containerName, (Object)"container");
        Preconditions.checkNotNull((Object)blob, (Object)"blob");
        final String name = blobName.apply(blob);
        if (name.indexOf(47) > 0) {
            this.userExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    SwiftBlobStore.this.createDirectory(containerName, SwiftBlobStore.parseDirectoryFromPath(name));
                }
            });
        }
    }

    private static String parseDirectoryFromPath(String path) {
        return ((String)Preconditions.checkNotNull((Object)path, (Object)"path")).substring(0, path.lastIndexOf(47));
    }

    public String putBlob(String container, Blob blob, PutOptions options) {
        if (options.isMultipart()) {
            return ((MultipartUploadStrategy)this.multipartUploadStrategy.get()).execute(container, blob);
        }
        return this.putBlob(container, blob);
    }

    public void removeBlob(String container, String key) {
        String objectManifest = this.getObjectManifestOrNull(container, key);
        this.sync.removeObject(container, key);
        if (!Strings.isNullOrEmpty((String)objectManifest)) {
            this.removeObjectsWithPrefix(objectManifest);
        }
    }

    private String getObjectManifestOrNull(String container, String key) {
        MutableObjectInfoWithMetadata objectInfo = this.sync.getObjectInfo(container, key);
        return objectInfo == null ? null : objectInfo.getObjectManifest();
    }

    private void removeObjectsWithPrefix(String containerAndPrefix) {
        String[] parts = SwiftBlobStore.splitContainerAndKey(containerAndPrefix);
        String container = parts[0];
        String prefix = parts[1];
        this.removeObjectsWithPrefix(container, prefix);
    }

    @VisibleForTesting
    static String[] splitContainerAndKey(String containerAndKey) {
        String[] parts = containerAndKey.split("/", 2);
        Preconditions.checkArgument((parts.length == 2 ? 1 : 0) != 0, (String)"No / separator found in \"%s\"", (Object[])new Object[]{containerAndKey});
        return parts;
    }

    private void removeObjectsWithPrefix(String container, String prefix) {
        PageSet<ObjectInfo> chunks;
        String nextMarker = null;
        do {
            ListContainerOptions listContainerOptions = ListContainerOptions.Builder.withPrefix(prefix);
            if (nextMarker != null) {
                listContainerOptions = listContainerOptions.afterMarker(nextMarker);
            }
            chunks = this.sync.listObjects(container, listContainerOptions);
            for (ObjectInfo chunk : chunks) {
                this.sync.removeObject(container, chunk.getName());
            }
        } while ((nextMarker = chunks.getNextMarker()) != null);
    }

    protected boolean deleteAndVerifyContainerGone(String container) {
        this.sync.deleteContainerIfEmpty(container);
        return !this.sync.containerExists(container);
    }

    public boolean createContainerInLocation(Location location, String container, CreateContainerOptions options) {
        if (options.isPublicRead()) {
            throw new UnsupportedOperationException("publicRead");
        }
        return this.createContainerInLocation(location, container);
    }
}

