/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.functions;

import com.google.common.base.Function;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.swift.domain.MutableObjectInfoWithMetadata;
import org.jclouds.openstack.swift.domain.SwiftObject;
import org.jclouds.openstack.swift.functions.ParseObjectInfoFromHeaders;
import org.jclouds.rest.InvocationContext;

public class ParseObjectFromHeadersAndHttpContent
implements Function<HttpResponse, SwiftObject>,
InvocationContext<ParseObjectFromHeadersAndHttpContent> {
    private final ParseObjectInfoFromHeaders infoParser;
    private final SwiftObject.Factory objectProvider;

    @Inject
    public ParseObjectFromHeadersAndHttpContent(ParseObjectInfoFromHeaders infoParser, SwiftObject.Factory objectProvider) {
        this.infoParser = infoParser;
        this.objectProvider = objectProvider;
    }

    public SwiftObject apply(HttpResponse from) {
        MutableObjectInfoWithMetadata metadata = this.infoParser.apply(from);
        if (metadata.getHash() != null) {
            from.getPayload().getContentMetadata().setContentMD5(metadata.getHash());
        }
        SwiftObject object = this.objectProvider.create(metadata);
        object.getAllHeaders().putAll(from.getHeaders());
        object.setPayload(from.getPayload());
        return object;
    }

    public ParseObjectFromHeadersAndHttpContent setContext(HttpRequest request) {
        this.infoParser.setContext(request);
        return this;
    }
}

