/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.binders;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.binders.BindUserMetadataToHeadersWithPrefix;
import org.jclouds.http.HttpRequest;
import org.jclouds.openstack.swift.blobstore.functions.ObjectToBlob;
import org.jclouds.openstack.swift.domain.SwiftObject;
import org.jclouds.rest.Binder;

@Singleton
public class BindSwiftObjectMetadataToRequest
implements Binder {
    private final BindUserMetadataToHeadersWithPrefix mdBinder;
    private final ObjectToBlob object2Blob;

    @Inject
    public BindSwiftObjectMetadataToRequest(ObjectToBlob object2Blob, BindUserMetadataToHeadersWithPrefix mdBinder) {
        this.mdBinder = mdBinder;
        this.object2Blob = object2Blob;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Date expires;
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof SwiftObject), (Object)"this binder is only valid for SwiftObject!");
        Preconditions.checkNotNull(request, (Object)"request");
        SwiftObject object = (SwiftObject)input;
        if (object.getPayload().getContentMetadata().getContentType() == null) {
            object.getPayload().getContentMetadata().setContentType("application/octet-stream");
        }
        if (object.getPayload().getContentMetadata().getContentLength() != null && object.getPayload().getContentMetadata().getContentLength() >= 0L) {
            Preconditions.checkArgument((object.getPayload().getContentMetadata().getContentLength() <= 0x140000000L ? 1 : 0) != 0, (Object)"maximum size for put object is 5GB");
        } else {
            request = ((HttpRequest.Builder)request.toBuilder().replaceHeader("Transfer-Encoding", new String[]{"chunked"})).build();
        }
        byte[] contentMD5 = object.getInfo().getHash();
        if (contentMD5 != null) {
            request = ((HttpRequest.Builder)request.toBuilder().addHeader("ETag", new String[]{BaseEncoding.base16().lowerCase().encode(contentMD5)})).build();
        }
        if ((expires = object.getPayload().getContentMetadata().getExpires()) != null) {
            request = ((HttpRequest.Builder)request.toBuilder().addHeader("X-Delete-At", new String[]{String.valueOf(TimeUnit.MILLISECONDS.toSeconds(expires.getTime()))})).build();
        }
        request = this.mdBinder.bindToRequest(request, (Object)this.object2Blob.apply(object));
        return request;
    }
}

