/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.MutableStorageMetadataImpl;
import org.jclouds.domain.Location;
import org.jclouds.openstack.swift.domain.ContainerMetadata;

@Singleton
public class ContainerToResourceMetadata
implements Function<ContainerMetadata, StorageMetadata> {
    private Supplier<Location> defaultLocation;

    @Inject
    ContainerToResourceMetadata(Supplier<Location> defaultLocation) {
        this.defaultLocation = defaultLocation;
    }

    public StorageMetadata apply(ContainerMetadata from) {
        MutableStorageMetadataImpl to = new MutableStorageMetadataImpl();
        to.setName(from.getName());
        to.setLocation((Location)this.defaultLocation.get());
        to.setType((Enum)StorageType.CONTAINER);
        return to;
    }
}

