/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hp.hpl.jena.sparql.engine.index;

import com.hp.hpl.jena.sparql.engine.binding.Binding;

/**
 * Interface for indexes that are used for identifying matching
 * {@link com.hp.hpl.jena.sparql.engine.binding.Binding}s when
 * {@link com.hp.hpl.jena.sparql.engine.iterator.QueryIterMinus} is trying to determine
 * which Bindings need to be removed.
 * @author Paul Gearon
 */
public interface IndexTable {

	public abstract boolean containsCompatibleWithSharedDomain(Binding binding);

}
