/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.optimize;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVars;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.op.Op2;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpBase;
import com.hp.hpl.jena.sparql.algebra.op.OpConditional;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpN;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpSequence;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.core.Substitute;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.E_SameTerm;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction2;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openjena.atlas.lib.CollectionUtils;
import org.openjena.atlas.lib.Pair;

public class TransformFilterEquality
extends TransformCopy {
    @Override
    public Op transform(OpFilter opFilter, Op subOp) {
        Op op = TransformFilterEquality.apply(opFilter.getExprs(), subOp);
        if (op == null) {
            return super.transform(opFilter, subOp);
        }
        return op;
    }

    private static Op apply(ExprList exprs, Op subOp) {
        Pair<List<Pair<Var, NodeValue>>, ExprList> p = TransformFilterEquality.preprocessFilterEquality(exprs);
        if (p == null || p.getLeft().size() == 0) {
            return null;
        }
        List<Pair<Var, NodeValue>> equalities = p.getLeft();
        Collection<Var> varsMentioned = TransformFilterEquality.varsMentionedInEqualityFilters(equalities);
        ExprList remaining = p.getRight();
        Op op = subOp;
        if (TransformFilterEquality.testSpecialCaseUnused(subOp, equalities, remaining)) {
            return OpTable.empty();
        }
        if (TransformFilterEquality.testSpecialCase1(subOp, equalities, remaining)) {
            List<Op> ops = TransformFilterEquality.extractOptionals(subOp);
            ops = TransformFilterEquality.processSpecialCase1(ops, equalities);
            op = TransformFilterEquality.rebuild((Op2)subOp, ops);
            op = OpFilter.filter(exprs, op);
            return op;
        }
        if (!TransformFilterEquality.safeToTransform(varsMentioned, op)) {
            return null;
        }
        for (Pair<Var, NodeValue> equalityTest : equalities) {
            op = TransformFilterEquality.processFilterWorker(op, equalityTest.getLeft(), equalityTest.getRight());
        }
        if (remaining.size() > 0) {
            op = OpFilter.filter(remaining, op);
        }
        return op;
    }

    private static Pair<List<Pair<Var, NodeValue>>, ExprList> preprocessFilterEquality(ExprList exprs) {
        ArrayList<Pair<Var, NodeValue>> exprsFilterEquality = new ArrayList<Pair<Var, NodeValue>>();
        ExprList exprsOther = new ExprList();
        for (Expr e2 : exprs.getList()) {
            Pair<Var, NodeValue> p = TransformFilterEquality.preprocess(e2);
            if (p != null) {
                exprsFilterEquality.add(p);
                continue;
            }
            exprsOther.add(e2);
        }
        if (exprsFilterEquality.size() == 0) {
            return null;
        }
        return Pair.create(exprsFilterEquality, exprsOther);
    }

    private static Pair<Var, NodeValue> preprocess(Expr e2) {
        if (!(e2 instanceof E_Equals) && !(e2 instanceof E_SameTerm)) {
            return null;
        }
        ExprFunction2 eq = (ExprFunction2)e2;
        Expr left = eq.getArg1();
        Expr right = eq.getArg2();
        Var var = null;
        NodeValue constant = null;
        if (left.isVariable() && right.isConstant()) {
            var = left.asVar();
            constant = right.getConstant();
        } else if (right.isVariable() && left.isConstant()) {
            var = right.asVar();
            constant = left.getConstant();
        }
        if (var == null || constant == null) {
            return null;
        }
        if (e2 instanceof E_SameTerm && !ARQ.isStrictMode() && constant.isString()) {
            return null;
        }
        if (e2 instanceof E_Equals && !ARQ.isStrictMode() && constant.isLiteral()) {
            return null;
        }
        return Pair.create(var, constant);
    }

    private static Collection<Var> varsMentionedInEqualityFilters(List<Pair<Var, NodeValue>> equalities) {
        ArrayList<Var> vars = new ArrayList<Var>();
        for (Pair<Var, NodeValue> p : equalities) {
            vars.add(p.getLeft());
        }
        return vars;
    }

    private static boolean safeToTransform(Collection<Var> varsEquality, Op op) {
        if (op instanceof OpBGP || op instanceof OpQuadPattern) {
            return true;
        }
        if (op instanceof OpFilter) {
            OpFilter opf = (OpFilter)op;
            Set<Var> fvars = opf.getExprs().getVarsMentioned();
            if (!CollectionUtils.disjoint(fvars, varsEquality)) {
                return false;
            }
            return TransformFilterEquality.safeToTransform(varsEquality, opf.getSubOp());
        }
        if (op instanceof OpSequence) {
            OpN opN = (OpN)op;
            for (Op subOp : opN.getElements()) {
                if (TransformFilterEquality.safeToTransform(varsEquality, subOp)) continue;
                return false;
            }
            return true;
        }
        if (op instanceof OpJoin || op instanceof OpUnion) {
            Op2 op2 = (Op2)op;
            return TransformFilterEquality.safeToTransform(varsEquality, op2.getLeft()) && TransformFilterEquality.safeToTransform(varsEquality, op2.getRight());
        }
        if (op instanceof OpConditional || op instanceof OpLeftJoin) {
            Op2 opleftjoin = (Op2)op;
            if (!TransformFilterEquality.safeToTransform(varsEquality, opleftjoin.getLeft()) || !TransformFilterEquality.safeToTransform(varsEquality, opleftjoin.getRight())) {
                return false;
            }
            Op opLeft = opleftjoin.getLeft();
            Set<Var> varsLeft = OpVars.patternVars(opLeft);
            return varsLeft.containsAll(varsEquality);
        }
        if (op instanceof OpGraph) {
            OpGraph opg = (OpGraph)op;
            return TransformFilterEquality.safeToTransform(varsEquality, opg.getSubOp());
        }
        return false;
    }

    private static boolean testSpecialCaseUnused(Op op, List<Pair<Var, NodeValue>> equalities, ExprList remaining) {
        Set<Var> patternVars = OpVars.patternVars(op);
        for (Pair<Var, NodeValue> p : equalities) {
            if (patternVars.contains((Object)p.getLeft())) continue;
            return true;
        }
        return false;
    }

    private static boolean testSpecialCase1(Op op, List<Pair<Var, NodeValue>> equalities, ExprList remaining) {
        while (op instanceof OpConditional || op instanceof OpLeftJoin) {
            Op2 opleftjoin2 = (Op2)op;
            op = opleftjoin2.getLeft();
        }
        return TransformFilterEquality.isUnitTable(op);
    }

    private static List<Op> extractOptionals(Op op) {
        ArrayList<Op> chain = new ArrayList<Op>();
        while (op instanceof OpConditional || op instanceof OpLeftJoin) {
            Op2 opleftjoin2 = (Op2)op;
            chain.add(opleftjoin2.getRight());
            op = opleftjoin2.getLeft();
        }
        return chain;
    }

    private static List<Op> processSpecialCase1(List<Op> ops, List<Pair<Var, NodeValue>> equalities) {
        ArrayList<Op> ops2 = new ArrayList<Op>();
        Collection<Var> vars = TransformFilterEquality.varsMentionedInEqualityFilters(equalities);
        Iterator<Op> i$ = ops.iterator();
        while (i$.hasNext()) {
            Op op;
            Op op2 = op = i$.next();
            if (TransformFilterEquality.safeToTransform(vars, op)) {
                for (Pair<Var, NodeValue> p : equalities) {
                    op2 = TransformFilterEquality.processFilterWorker(op, p.getLeft(), p.getRight());
                }
            }
            ops2.add(op2);
        }
        return ops2;
    }

    private static Op rebuild(Op2 subOp, List<Op> ops) {
        OpBase chain = OpTable.unit();
        for (Op op : ops) {
            chain = subOp.copy(chain, op);
        }
        return chain;
    }

    private static boolean isUnitTable(Op op) {
        return op instanceof OpTable && ((OpTable)op).isJoinIdentity();
    }

    private static Op processFilterWorker(Op op, Var var, NodeValue constant) {
        return TransformFilterEquality.subst(op, var, constant);
    }

    private static Op subst(Op subOp, Var var, NodeValue nv) {
        Op op = Substitute.substitute(subOp, var, nv.asNode());
        return OpAssign.assign(op, var, nv);
    }

    static Op processFilter(Expr e2, Op subOp) {
        return TransformFilterEquality.apply(new ExprList(e2), subOp);
    }
}

