/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.writers.WriterNode;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.openjena.atlas.io.IndentedLineBuffer;
import org.openjena.atlas.io.IndentedWriter;

public class QuadPattern
implements Iterable<Quad> {
    private List<Quad> quads = new ArrayList<Quad>();

    public QuadPattern() {
    }

    public QuadPattern(QuadPattern other) {
        this.quads.addAll(other.quads);
    }

    public void add(Quad q) {
        this.quads.add(q);
    }

    public void addAll(QuadPattern other) {
        this.quads.addAll(other.quads);
    }

    public void add(int i, Quad q) {
        this.quads.add(i, q);
    }

    public Quad get(int i) {
        return this.quads.get(i);
    }

    @Override
    public ListIterator<Quad> iterator() {
        return this.quads.listIterator();
    }

    public int size() {
        return this.quads.size();
    }

    public boolean isEmpty() {
        return this.quads.isEmpty();
    }

    public List<Quad> getList() {
        return this.quads;
    }

    public int hashCode() {
        return this.quads.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof QuadPattern)) {
            return false;
        }
        QuadPattern bp = (QuadPattern)other;
        return this.quads.equals(bp.quads);
    }

    public String toString() {
        IndentedLineBuffer out = new IndentedLineBuffer();
        SerializationContext sCxt = SSE.sCxt(SSE.defaultPrefixMapWrite);
        boolean first = true;
        for (Quad quad : this.quads) {
            if (!first) {
                out.print(" ");
            } else {
                first = false;
            }
            out.print("(");
            WriterNode.outputPlain((IndentedWriter)out, quad, sCxt);
            out.print(")");
        }
        out.flush();
        return out.toString();
    }
}

