/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.optimizer.reorder;

import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.engine.optimizer.StatsMatcher;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderFixed;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderProc;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderWeighted;

public class ReorderLib {
    private static ReorderProc _identityProc = new ReorderProcIdentity();
    private static ReorderTransformation _identity = new ReorderTransformationIdentity();

    public static ReorderProc identityProc() {
        return _identityProc;
    }

    public static ReorderTransformation identity() {
        return _identity;
    }

    public static ReorderTransformation fixed() {
        return new ReorderFixed();
    }

    public static ReorderTransformation weighted(String filename) {
        StatsMatcher stats = new StatsMatcher(filename);
        return new ReorderWeighted(stats);
    }

    private static class ReorderTransformationIdentity
    implements ReorderTransformation {
        private ReorderTransformationIdentity() {
        }

        @Override
        public BasicPattern reorder(BasicPattern pattern) {
            return pattern;
        }

        @Override
        public ReorderProc reorderIndexes(BasicPattern pattern) {
            return _identityProc;
        }
    }

    private static class ReorderProcIdentity
    implements ReorderProc {
        private ReorderProcIdentity() {
        }

        @Override
        public BasicPattern reorder(BasicPattern pattern) {
            return pattern;
        }

        public String toString() {
            return "identity reorder";
        }
    }
}

