/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.lib;

import java.util.Map;
import org.openjena.atlas.lib.ActionKeyValue;

public class MapUtils {
    private MapUtils() {
    }

    public static <K, V> void apply(Map<K, V> map, ActionKeyValue<K, V> action) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            action.apply(entry.getKey(), entry.getValue());
        }
    }

    public static <T> void increment(Map<T, Integer> countMap, T key) {
        MapUtils.increment(countMap, key, 1);
    }

    public static <T> void increment(Map<T, Integer> countMap, T key, int incr) {
        Integer integer = countMap.get(key);
        if (integer == null) {
            countMap.put(key, incr);
        } else {
            countMap.put(key, integer + incr);
        }
    }
}

