/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.iterator.IteratorConcat;

public abstract class MultiMap<K, V> {
    private Map<K, Collection<V>> map = new HashMap<K, Collection<V>>();

    protected abstract Collection<V> create();

    public static <K, V> MultiMap<K, V> createMapList() {
        return new MultiMapToList();
    }

    public static <K, V> MultiMap<K, V> createMapSet() {
        return new MultiMapToSet();
    }

    protected MultiMap() {
    }

    public Collection<V> get(K key) {
        return this.map.get(key);
    }

    public void putAll(K key, V ... values) {
        for (V v : values) {
            this.put(key, v);
        }
    }

    public void put(K key, V value) {
        Collection<V> x = this.map.get(key);
        if (x == null) {
            x = this.create();
            this.map.put(key, x);
        }
        x.add(value);
    }

    public Collection<V> values(K key) {
        return this.map.get(key);
    }

    public Collection<V> values() {
        return Iter.toList(this.flatten());
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public Set<K> keys() {
        return this.map.keySet();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Iterator<V> flatten() {
        IteratorConcat<V> all = new IteratorConcat<V>();
        for (K k : this.map.keySet()) {
            Collection<V> x = this.map.get(k);
            all.add(x.iterator());
        }
        return all;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MultiMap)) {
            return true;
        }
        MultiMap mmap = (MultiMap)other;
        return this.map.equals(mmap.map);
    }

    public int hashCode() {
        return this.map.hashCode() ^ 0x1010101;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        boolean firstKey = true;
        for (K key : this.keys()) {
            if (!firstKey) {
                sb.append(", ");
            }
            firstKey = false;
            sb.append(key);
            sb.append(" [");
            boolean firstValue = true;
            for (V value : this.values(key)) {
                if (firstValue) {
                    sb.append(" ");
                } else {
                    sb.append(", ");
                }
                sb.append(value);
                firstValue = false;
            }
            sb.append(" ] ");
        }
        sb.append("}");
        return sb.toString();
    }

    static class MultiMapToSet<K, V>
    extends MultiMap<K, V> {
        MultiMapToSet() {
        }

        @Override
        protected Collection<V> create() {
            return new HashSet();
        }
    }

    static class MultiMapToList<K, V>
    extends MultiMap<K, V> {
        MultiMapToList() {
        }

        @Override
        protected Collection<V> create() {
            return new ArrayList();
        }
    }
}

