/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import java.io.InputStream;
import java.util.Iterator;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.io.PeekReader;
import org.openjena.atlas.iterator.IteratorResourceClosing;
import org.openjena.atlas.json.io.parser.TokenizerJSON;
import org.openjena.atlas.lib.IRILib;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.ErrorHandlerFactory;
import org.openjena.riot.Lang;
import org.openjena.riot.RiotException;
import org.openjena.riot.RiotQuadParsePuller;
import org.openjena.riot.RiotTripleParsePuller;
import org.openjena.riot.lang.LangNQuads;
import org.openjena.riot.lang.LangNTriples;
import org.openjena.riot.lang.LangRDFJSON;
import org.openjena.riot.lang.LangRDFXML;
import org.openjena.riot.lang.LangRIOT;
import org.openjena.riot.lang.LangTriG;
import org.openjena.riot.lang.LangTurtle;
import org.openjena.riot.system.IRIResolver;
import org.openjena.riot.system.RiotLib;
import org.openjena.riot.system.SinkExtendTriplesToQuads;
import org.openjena.riot.tokens.Tokenizer;
import org.openjena.riot.tokens.TokenizerFactory;

public class RiotReader {
    public static void parseTriples(String filename, Sink<Triple> sink) {
        RiotReader.parseTriples(filename, null, null, sink);
    }

    public static void parseTriples(String filename, Lang lang, String baseIRI, Sink<Triple> sink) {
        RiotReader.checkTriplesLanguage(filename, lang);
        InputStream in = IO.openFile(filename);
        String base = RiotReader.chooseBaseIRI(baseIRI, filename);
        if (lang == null) {
            lang = Lang.guess(filename, Lang.NTRIPLES);
        }
        if (lang == Lang.RDFXML) {
            LangRDFXML.create(in, base, filename, ErrorHandlerFactory.getDefaultErrorHandler(), sink).parse();
            IO.close(in);
            return;
        }
        RiotReader.parseTriples(in, lang, base, sink);
        IO.close(in);
    }

    public static void parseTriples(InputStream in, Lang lang, String baseIRI, Sink<Triple> sink) {
        LangRIOT parser = RiotReader.createParserTriples(in, lang, baseIRI, sink);
        parser.parse();
    }

    public static void parseQuads(String filename, Sink<Quad> sink) {
        RiotReader.parseQuads(filename, null, null, sink);
    }

    public static void parseQuads(String filename, Lang lang, String baseIRI, Sink<Quad> sink) {
        InputStream in = IO.openFile(filename);
        String base = RiotReader.chooseBaseIRI(baseIRI, filename);
        if (lang == null) {
            lang = Lang.guess(filename, Lang.NQUADS);
        }
        RiotReader.parseQuads(in, lang, base, sink);
        IO.close(in);
    }

    public static void parseQuads(InputStream in, Lang lang, String baseIRI, Sink<Quad> sink) {
        LangRIOT parser = RiotReader.createParserQuads(in, lang, baseIRI, sink);
        parser.parse();
    }

    public static LangRIOT createParserTriples(InputStream input, Lang lang, String baseIRI, Sink<Triple> sink) {
        if (lang == Lang.RDFXML) {
            if (baseIRI != null) {
                baseIRI = IRIResolver.resolveString(baseIRI);
            }
            return LangRDFXML.create(input, baseIRI, baseIRI, ErrorHandlerFactory.getDefaultErrorHandler(), sink);
        }
        Tokenizer tokenizer = lang == Lang.RDFJSON ? new TokenizerJSON(PeekReader.makeUTF8(input)) : TokenizerFactory.makeTokenizerUTF8(input);
        return RiotReader.createParserTriples(tokenizer, lang, baseIRI, sink);
    }

    public static LangRIOT createParserTriples(Tokenizer tokenizer, Lang lang, String baseIRI, Sink<Triple> sink) {
        switch (lang) {
            case N3: 
            case TURTLE: {
                return RiotReader.createParserTurtle(tokenizer, baseIRI, sink);
            }
            case NTRIPLES: {
                return RiotReader.createParserNTriples(tokenizer, sink);
            }
            case RDFJSON: {
                return RiotReader.createParserRdfJson(tokenizer, sink);
            }
            case RDFXML: {
                throw new RiotException("Not possible - can't parse RDF/XML from a RIOT token stream");
            }
            case NQUADS: 
            case TRIG: {
                throw new RiotException("Not a triples language: " + (Object)((Object)lang));
            }
        }
        return null;
    }

    public static Iterator<Triple> createIteratorTriples(InputStream input, Lang lang, String baseIRI) {
        if (lang == Lang.NTRIPLES) {
            return new IteratorResourceClosing<Triple>(RiotReader.createParserNTriples(input, null), input);
        }
        RiotTripleParsePuller parsePuller = new RiotTripleParsePuller(input, lang, baseIRI);
        parsePuller.parse();
        return parsePuller;
    }

    public static LangRIOT createParserQuads(InputStream input, Lang lang, String baseIRI, Sink<Quad> sink) {
        if (lang.isTriples()) {
            SinkExtendTriplesToQuads converter = new SinkExtendTriplesToQuads(sink);
            return RiotReader.createParserTriples(input, lang, baseIRI, (Sink<Triple>)converter);
        }
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerUTF8(input);
        return RiotReader.createParserQuads(tokenizer, lang, baseIRI, sink);
    }

    public static LangRIOT createParserQuads(Tokenizer tokenizer, Lang lang, String baseIRI, Sink<Quad> sink) {
        switch (lang) {
            case N3: 
            case TURTLE: 
            case NTRIPLES: 
            case RDFJSON: 
            case RDFXML: {
                SinkExtendTriplesToQuads converter = new SinkExtendTriplesToQuads(sink);
                return RiotReader.createParserTriples(tokenizer, lang, baseIRI, (Sink<Triple>)converter);
            }
            case NQUADS: {
                return RiotReader.createParserNQuads(tokenizer, sink);
            }
            case TRIG: {
                return RiotReader.createParserTriG(tokenizer, baseIRI, sink);
            }
        }
        return null;
    }

    public static Iterator<Quad> createIteratorQuads(InputStream input, Lang lang, String baseIRI) {
        if (lang == Lang.NTRIPLES) {
            return new IteratorResourceClosing<Quad>(RiotReader.createParserNQuads(input, null), input);
        }
        RiotQuadParsePuller parsePuller = new RiotQuadParsePuller(input, lang, baseIRI);
        parsePuller.parse();
        return parsePuller;
    }

    public static LangTurtle createParserTurtle(InputStream input, String baseIRI, Sink<Triple> sink) {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerUTF8(input);
        return RiotReader.createParserTurtle(tokenizer, baseIRI, sink);
    }

    public static LangTurtle createParserTurtle(Tokenizer tokenizer, String baseIRI, Sink<Triple> sink) {
        LangTurtle parser = new LangTurtle(tokenizer, RiotLib.profile(Lang.TURTLE, baseIRI), sink);
        return parser;
    }

    public static LangRDFXML createParserRDFXML(InputStream input, String baseIRI, Sink<Triple> sink) {
        if (baseIRI == null) {
            baseIRI = RiotReader.chooseBaseIRI();
        }
        LangRDFXML parser = LangRDFXML.create(input, baseIRI, baseIRI, ErrorHandlerFactory.getDefaultErrorHandler(), sink);
        return parser;
    }

    public static LangRDFJSON createParserRdfJson(Tokenizer tokenizer, Sink<Triple> sink) {
        LangRDFJSON parser = new LangRDFJSON(tokenizer, RiotLib.profile(Lang.RDFJSON, null), sink);
        return parser;
    }

    public static LangRDFJSON createParserRdfJson(InputStream input, Sink<Triple> sink) {
        TokenizerJSON tokenizer = new TokenizerJSON(PeekReader.makeUTF8(input));
        return RiotReader.createParserRdfJson(tokenizer, sink);
    }

    public static LangTriG createParserTriG(InputStream input, String baseIRI, Sink<Quad> sink) {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerUTF8(input);
        return RiotReader.createParserTriG(tokenizer, baseIRI, sink);
    }

    public static LangTriG createParserTriG(Tokenizer tokenizer, String baseIRI, Sink<Quad> sink) {
        if (baseIRI == null) {
            baseIRI = RiotReader.chooseBaseIRI();
        }
        LangTriG parser = new LangTriG(tokenizer, RiotLib.profile(Lang.TRIG, baseIRI), sink);
        return parser;
    }

    public static LangNTriples createParserNTriples(InputStream input, Sink<Triple> sink) {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerASCII(input);
        return RiotReader.createParserNTriples(tokenizer, sink);
    }

    public static LangNTriples createParserNTriples(Tokenizer tokenizer, Sink<Triple> sink) {
        LangNTriples parser = new LangNTriples(tokenizer, RiotLib.profile(Lang.NTRIPLES, null), sink);
        return parser;
    }

    public static LangNQuads createParserNQuads(InputStream input, Sink<Quad> sink) {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerASCII(input);
        return RiotReader.createParserNQuads(tokenizer, sink);
    }

    public static LangNQuads createParserNQuads(Tokenizer tokenizer, Sink<Quad> sink) {
        LangNQuads parser = new LangNQuads(tokenizer, RiotLib.profile(Lang.NQUADS, null), sink);
        return parser;
    }

    public static String chooseBaseIRI() {
        return IRIResolver.chooseBaseURI().toString();
    }

    public static String chooseBaseIRI(String baseIRI, String filename) {
        if (baseIRI != null) {
            return baseIRI;
        }
        if (filename == null || filename.equals("-")) {
            return "http://localhost/stdin/";
        }
        String x = IRILib.filenameToIRI(filename);
        return x;
    }

    private static String nameForFile(String filename) {
        if (filename == null || filename.equals("-")) {
            return "stdin";
        }
        return filename;
    }

    private static void checkTriplesLanguage(String filename, Lang lang) {
        if (lang != null) {
            if (!lang.isTriples()) {
                throw new RiotException("Can only parse triples languages to a triples sink: " + lang.getName());
            }
            return;
        }
        lang = Lang.guess(filename);
        if (lang != null && !lang.isTriples()) {
            throw new RiotException("Can only parse triples languages to a triples sink: " + lang.getName());
        }
    }
}

