/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot;

import com.hp.hpl.jena.rdf.model.impl.RDFReaderFImpl;
import com.hp.hpl.jena.rdf.model.impl.RDFWriterFImpl;
import org.openjena.atlas.event.EventType;
import org.openjena.riot.system.JenaReaderNTriples2;
import org.openjena.riot.system.JenaReaderRdfJson;
import org.openjena.riot.system.JenaReaderTurtle2;
import org.openjena.riot.system.JenaWriterRdfJson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysRIOT {
    public static final String riotLoggerName = "org.openjena.riot";
    private static Logger riotLogger = LoggerFactory.getLogger((String)"org.openjena.riot");
    public static final EventType startRead = new EventType(SysRIOT.class, "StartRead");
    public static final EventType finishRead = new EventType(SysRIOT.class, "FinishRead");
    public static boolean StrictXSDLexicialForms = false;
    public static final String BNodeGenIdPrefix = "genid";
    static String jenaNTriplesReader = "com.hp.hpl.jena.rdf.model.impl.NTripleReader";
    static String jenaTurtleReader;
    static String jenaN3Reader;

    public static String fmtMessage(String message, long line, long col) {
        if (col == -1L && line == -1L) {
            return message;
        }
        if (col == -1L && line != -1L) {
            return String.format("[line: %d] %s", line, message);
        }
        if (col != -1L && line == -1L) {
            return String.format("[col: %d] %s", col, message);
        }
        return String.format("[line: %d, col: %-2d] %s", line, col, message);
    }

    public static Logger getLogger() {
        return riotLogger;
    }

    public static void wireIntoJena() {
        String readerNT = JenaReaderNTriples2.class.getName();
        RDFReaderFImpl.setBaseReaderClassName((String)"N-TRIPLES", (String)readerNT);
        RDFReaderFImpl.setBaseReaderClassName((String)"N-TRIPLE", (String)readerNT);
        String readerTTL = JenaReaderTurtle2.class.getName();
        RDFReaderFImpl.setBaseReaderClassName((String)"N3", (String)readerTTL);
        RDFReaderFImpl.setBaseReaderClassName((String)"TURTLE", (String)readerTTL);
        RDFReaderFImpl.setBaseReaderClassName((String)"Turtle", (String)readerTTL);
        RDFReaderFImpl.setBaseReaderClassName((String)"TTL", (String)readerTTL);
        String readerRdfJson = JenaReaderRdfJson.class.getName();
        RDFReaderFImpl.setBaseReaderClassName((String)"RDF/JSON", (String)readerRdfJson);
        String writerRdfJson = JenaWriterRdfJson.class.getName();
        RDFWriterFImpl.setBaseWriterClassName((String)"RDF/JSON", (String)writerRdfJson);
    }

    public static void resetJenaReaders() {
        RDFReaderFImpl.setBaseReaderClassName((String)"N-TRIPLES", (String)jenaNTriplesReader);
        RDFReaderFImpl.setBaseReaderClassName((String)"N-TRIPLE", (String)jenaNTriplesReader);
        RDFReaderFImpl.setBaseReaderClassName((String)"N3", (String)jenaTurtleReader);
        RDFReaderFImpl.setBaseReaderClassName((String)"TURTLE", (String)jenaTurtleReader);
        RDFReaderFImpl.setBaseReaderClassName((String)"Turtle", (String)jenaTurtleReader);
        RDFReaderFImpl.setBaseReaderClassName((String)"TTL", (String)jenaTurtleReader);
        RDFReaderFImpl.setBaseReaderClassName((String)"RDF/JSON", (String)"");
        RDFWriterFImpl.setBaseWriterClassName((String)"RDF/JSON", (String)"");
    }

    static {
        jenaN3Reader = jenaTurtleReader = "com.hp.hpl.jena.n3.turtle.TurtleReader";
    }
}

