/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.lib.Sink;
import org.openjena.atlas.web.TypedInputStream;
import org.openjena.riot.Lang;
import org.openjena.riot.RiotException;
import org.openjena.riot.RiotLoader;

public class WebReader {
    private static Map<String, Lang> contentTypeToLang = new HashMap<String, Lang>();

    public static void readGraph(Graph graph, String uri) {
        Lang lang = Lang.guess(uri);
        WebReader.readGraph(graph, uri, lang);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readGraph(Graph graph, String uri, Lang lang) {
        TypedInputStream typedInput = WebReader.open(uri, lang);
        String contentType = typedInput.getMediaType();
        if ((lang = WebReader.chooseLang(contentType, lang)) == null) {
            throw new RiotException("Can't determine the syntax of <" + uri + "> (media type=" + typedInput.getMediaType() + ")");
        }
        Sink<Triple> sink = RiotLoader.graphSink(graph);
        try {
            RiotLoader.readTriples(typedInput, lang, uri, sink);
        }
        finally {
            sink.close();
        }
    }

    private static Lang chooseLang(String contentType, Lang lang) {
        contentType = contentType.toLowerCase();
        return contentTypeToLang.get(contentType);
    }

    public static void readDataset(DatasetGraph dataset, String uri) {
        Lang lang = Lang.guess(uri);
        WebReader.readDataset(dataset, uri, lang);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readDataset(DatasetGraph dataset, String uri, Lang lang) {
        TypedInputStream typedInput = WebReader.open(uri, lang);
        String contentType = typedInput.getMediaType();
        if ((lang = WebReader.chooseLang(contentType, lang)) == null) {
            throw new RiotException("Can't determine the syntax of <" + uri + "> (media type=" + typedInput.getMediaType() + ")");
        }
        Sink<Quad> sink = RiotLoader.datasetSink(dataset);
        try {
            RiotLoader.readQuads(typedInput, lang, uri, sink);
        }
        finally {
            sink.close();
        }
    }

    private static TypedInputStream open(String uri, Lang lang) {
        try {
            FileInputStream in = new FileInputStream(uri);
            return new TypedInputStream(in, lang.getContentType(), null);
        }
        catch (IOException ex) {
            IO.exception(ex);
            return null;
        }
    }

    static {
        contentTypeToLang.put("text/rdf+n3".toLowerCase(), Lang.N3);
        contentTypeToLang.put("application/n3".toLowerCase(), Lang.N3);
        contentTypeToLang.put("text/n3".toLowerCase(), Lang.N3);
        contentTypeToLang.put("text/turtle".toLowerCase(), Lang.TURTLE);
        contentTypeToLang.put("application/turtle".toLowerCase(), Lang.TURTLE);
        contentTypeToLang.put("application/x-turtle".toLowerCase(), Lang.TURTLE);
        contentTypeToLang.put("application/n-triples".toLowerCase(), Lang.NTRIPLES);
        contentTypeToLang.put("text/plain".toLowerCase(), Lang.NTRIPLES);
        contentTypeToLang.put("application/rdf+xml".toLowerCase(), Lang.RDFXML);
        contentTypeToLang.put("application/trig".toLowerCase(), Lang.TRIG);
        contentTypeToLang.put("application/x-trig".toLowerCase(), Lang.TRIG);
        contentTypeToLang.put("text/nquads".toLowerCase(), Lang.NQUADS);
        contentTypeToLang.put("text/x-nquads".toLowerCase(), Lang.NQUADS);
    }

    static interface SinkTriplesFactory {
        public Process<Triple> create(String var1);
    }

    static interface Process<T> {
        public void parse(InputStream var1);
    }
}

