/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.lang;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.ARP;
import com.hp.hpl.jena.rdf.arp.ARPOptions;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.NamespaceHandler;
import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.jena.rdf.arp.StatementHandler;
import com.hp.hpl.jena.rdf.arp.impl.ARPSaxErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.ErrorHandler;
import org.openjena.riot.Lang;
import org.openjena.riot.checker.CheckerLiterals;
import org.openjena.riot.lang.LangRIOT;
import org.openjena.riot.system.ParserProfile;
import org.openjena.riot.system.RiotLib;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class LangRDFXML
implements LangRIOT {
    private ARP arp = new ARP();
    private long count = 0L;
    private InputStream input = null;
    private Reader reader = null;
    private String xmlBase;
    private String filename;
    private Sink<Triple> sink;
    private ParserProfile profile;
    public static boolean RiotUniformCompatibility = false;
    private static int[] additionalErrors = new int[]{115};

    @Override
    public ParserProfile getProfile() {
        return this.profile;
    }

    @Override
    public void setProfile(ParserProfile profile) {
        this.profile = profile;
    }

    public static LangRDFXML create(InputStream in, String xmlBase, String filename, ErrorHandler errorHandler, Sink<Triple> sink) {
        return new LangRDFXML(in, xmlBase, filename, errorHandler, sink);
    }

    @Deprecated
    public static LangRDFXML create(Reader reader, String xmlBase, String filename, ErrorHandler errorHandler, Sink<Triple> sink) {
        return new LangRDFXML(reader, xmlBase, filename, errorHandler, sink);
    }

    public static LangRDFXML create(String xmlBase, String filename, ErrorHandler errorHandler, Sink<Triple> sink) {
        return LangRDFXML.create(IO.openFile(filename), xmlBase, filename, errorHandler, sink);
    }

    private LangRDFXML(Reader reader, String xmlBase, String filename, ErrorHandler errorHandler, Sink<Triple> sink) {
        this.reader = reader;
        this.xmlBase = xmlBase;
        this.filename = filename;
        this.sink = sink;
        this.profile = RiotLib.profile(this.getLang(), xmlBase, errorHandler);
    }

    private LangRDFXML(InputStream in, String xmlBase, String filename, ErrorHandler errorHandler, Sink<Triple> sink) {
        this.input = in;
        this.xmlBase = xmlBase;
        this.filename = filename;
        this.sink = sink;
        this.profile = RiotLib.profile(this.getLang(), xmlBase, errorHandler);
    }

    @Override
    public Lang getLang() {
        return Lang.RDFXML;
    }

    @Override
    public void parse() {
        this.count = 0L;
        HandlerSink rslt = new HandlerSink(this.sink, this.getProfile().getHandler());
        this.arp.getHandlers().setStatementHandler((StatementHandler)rslt);
        this.arp.getHandlers().setErrorHandler((org.xml.sax.ErrorHandler)((Object)rslt));
        this.arp.getHandlers().setNamespaceHandler((NamespaceHandler)rslt);
        if (RiotUniformCompatibility) {
            ARPOptions options = this.arp.getOptions();
            for (int code : additionalErrors) {
                options.setErrorMode(code, 3);
            }
            this.arp.setOptionsWith(options);
        }
        try {
            if (this.reader != null) {
                this.arp.load(this.reader, this.xmlBase);
            } else {
                this.arp.load(this.input, this.xmlBase);
            }
        }
        catch (IOException e2) {
            this.getProfile().getHandler().error(this.filename + ": " + ParseException.formatMessage((Exception)e2), -1L, -1L);
        }
        catch (SAXParseException e3) {
        }
        catch (SAXException sax) {
            this.getProfile().getHandler().error(this.filename + ": " + ParseException.formatMessage((Exception)sax), -1L, -1L);
        }
        this.sink.flush();
    }

    private static class ErrorHandlerBridge
    implements RDFErrorHandler {
        private ErrorHandler errorHandler;

        ErrorHandlerBridge(ErrorHandler hander) {
            this.errorHandler = hander;
        }

        public void warning(Exception e2) {
            this.errorHandler.warning(e2.getMessage(), -1L, -1L);
        }

        public void error(Exception e2) {
            this.errorHandler.error(e2.getMessage(), -1L, -1L);
        }

        public void fatalError(Exception e2) {
            this.errorHandler.fatal(e2.getMessage(), -1L, -1L);
        }
    }

    private static class HandlerSink
    extends ARPSaxErrorHandler
    implements StatementHandler,
    NamespaceHandler {
        private Sink<Triple> sink;
        private ErrorHandler errHandler;
        private CheckerLiterals checker;

        HandlerSink(Sink<Triple> sink, ErrorHandler errHandler) {
            super((RDFErrorHandler)new ErrorHandlerBridge(errHandler));
            this.sink = sink;
            this.errHandler = errHandler;
            this.checker = new CheckerLiterals(errHandler);
        }

        public void statement(AResource subj, AResource pred, AResource obj) {
            this.sink.send(this.convert(subj, pred, obj));
        }

        public void statement(AResource subj, AResource pred, ALiteral lit) {
            this.sink.send(this.convert(subj, pred, lit));
        }

        private static Node convert(ALiteral lit) {
            String dtURI = lit.getDatatypeURI();
            if (dtURI == null) {
                return Node.createLiteral((String)lit.toString(), (String)lit.getLang(), (boolean)false);
            }
            if (lit.isWellFormedXML()) {
                return Node.createLiteral((String)lit.toString(), null, (boolean)true);
            }
            RDFDatatype dt = TypeMapper.getInstance().getSafeTypeByName(dtURI);
            return Node.createLiteral((String)lit.toString(), null, (RDFDatatype)dt);
        }

        private static Node convert(AResource r) {
            if (!r.isAnonymous()) {
                return Node.createURI((String)r.getURI());
            }
            Node rr = (Node)r.getUserData();
            if (rr == null) {
                rr = Node.createAnon();
                r.setUserData((Object)rr);
            }
            return rr;
        }

        private Triple convert(AResource s, AResource p, AResource o) {
            return Triple.create((Node)HandlerSink.convert(s), (Node)HandlerSink.convert(p), (Node)HandlerSink.convert(o));
        }

        private Triple convert(AResource s, AResource p, ALiteral o) {
            Node object = HandlerSink.convert(o);
            this.checker.check(object, -1L, -1L);
            return Triple.create((Node)HandlerSink.convert(s), (Node)HandlerSink.convert(p), (Node)object);
        }

        public void endPrefixMapping(String prefix) {
        }

        public void startPrefixMapping(String prefix, String uri) {
        }
    }
}

