/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.out;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Quad;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.out.NodeFormatter;
import org.openjena.riot.out.NodeFormatterNT;
import org.openjena.riot.out.NodeToLabel;
import org.openjena.riot.system.Prologue;
import org.openjena.riot.system.SyntaxLabels;

public class SinkQuadOutput
implements Sink<Quad> {
    private Prologue prologue = null;
    private Writer out;
    private NodeToLabel labelPolicy = null;
    private NodeFormatter nodeFmt = new NodeFormatterNT();

    public SinkQuadOutput(OutputStream outs) {
        this(outs, null, SyntaxLabels.createNodeToLabel());
    }

    public SinkQuadOutput(OutputStream outs, Prologue prologue, NodeToLabel labels) {
        this.out = IO.asBufferedUTF8(outs);
        this.setPrologue(prologue);
        this.setLabelPolicy(labels);
    }

    public void setPrologue(Prologue prologue) {
        this.prologue = prologue;
    }

    public void setLabelPolicy(NodeToLabel labels) {
        this.labelPolicy = labels;
    }

    @Override
    public void send(Quad quad) {
        try {
            Node s = quad.getSubject();
            Node p = quad.getPredicate();
            Node o = quad.getObject();
            Node g = quad.getGraph();
            this.nodeFmt.format(this.out, s);
            this.out.write(" ");
            this.nodeFmt.format(this.out, p);
            this.out.write(" ");
            this.nodeFmt.format(this.out, o);
            if (SinkQuadOutput.outputGraphSlot(g)) {
                this.out.write(" ");
                this.nodeFmt.format(this.out, g);
            }
            this.out.write(" .\n");
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    private static boolean outputGraphSlot(Node g) {
        return g != null && g != Quad.tripleInQuad && !Quad.isDefaultGraph(g);
    }

    @Override
    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    @Override
    public void close() {
        IO.flush(this.out);
    }
}

