/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.system;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQConstants;
import org.openjena.atlas.logging.Log;
import org.openjena.riot.ErrorHandler;
import org.openjena.riot.ErrorHandlerFactory;
import org.openjena.riot.Lang;
import org.openjena.riot.system.IRIResolver;
import org.openjena.riot.system.ParserProfile;
import org.openjena.riot.system.ParserProfileBase;
import org.openjena.riot.system.ParserProfileChecker;
import org.openjena.riot.system.PrefixMap;
import org.openjena.riot.system.Prologue;
import org.openjena.riot.tokens.Token;
import org.openjena.riot.tokens.Tokenizer;
import org.openjena.riot.tokens.TokenizerFactory;

public class RiotLib {
    static ParserProfile profile = RiotLib.profile(Lang.TURTLE, null, null);

    public static Node parse(String string) {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerString(string);
        if (!tokenizer.hasNext()) {
            return null;
        }
        Token t = tokenizer.next();
        Node n = profile.create(null, t);
        if (tokenizer.hasNext()) {
            Log.warn(RiotLib.class, "String has more than one token in it: " + string);
        }
        return n;
    }

    public static ParserProfile profile(Lang lang, String baseIRI) {
        return RiotLib.profile(lang, baseIRI, ErrorHandlerFactory.getDefaultErrorHandler());
    }

    public static ParserProfile profile(Lang lang, String baseIRI, ErrorHandler handler) {
        switch (lang) {
            case NQUADS: 
            case NTRIPLES: {
                return RiotLib.profile(baseIRI, false, false, handler);
            }
            case RDFJSON: {
                return RiotLib.profile(baseIRI, false, true, handler);
            }
            case N3: 
            case TURTLE: 
            case TRIG: 
            case RDFXML: {
                return RiotLib.profile(baseIRI, true, true, handler);
            }
        }
        return null;
    }

    public static ParserProfile profile(String baseIRI, boolean resolveIRIs, boolean checking, ErrorHandler handler) {
        Prologue prologue = resolveIRIs ? new Prologue(new PrefixMap(), IRIResolver.create(baseIRI)) : new Prologue(new PrefixMap(), IRIResolver.createNoResolve());
        if (checking) {
            return new ParserProfileChecker(prologue, handler);
        }
        return new ParserProfileBase(prologue, handler);
    }

    static {
        PrefixMap pmap = profile.getPrologue().getPrefixMap();
        pmap.add("rdf", ARQConstants.rdfPrefix);
        pmap.add("rdfs", ARQConstants.rdfsPrefix);
        pmap.add("xsd", "http://www.w3.org/2001/XMLSchema#");
        pmap.add("owl", ARQConstants.owlPrefix);
        pmap.add("fn", "http://www.w3.org/2005/xpath-functions#");
        pmap.add("op", "http://www.w3.org/2005/xpath-functions#");
        pmap.add("ex", "http://example/ns#");
        pmap.add("", "http://example/");
    }
}

