/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.modify;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.modify.UpdateEngineFactory;
import org.apache.jena.sparql.modify.UpdateEngineMain;
import org.apache.jena.sparql.util.Context;

public class UpdateEngineRegistry {
    List<UpdateEngineFactory> factories = new ArrayList<UpdateEngineFactory>();
    static UpdateEngineRegistry registry;

    public static UpdateEngineRegistry get() {
        if (registry == null) {
            UpdateEngineRegistry.init();
        }
        return registry;
    }

    private UpdateEngineRegistry() {
    }

    private static synchronized void init() {
        registry = new UpdateEngineRegistry();
        registry.add(UpdateEngineMain.getFactory());
    }

    public static UpdateEngineFactory findFactory(DatasetGraph graphStore, Context context2) {
        return UpdateEngineRegistry.get().find(graphStore, context2);
    }

    public UpdateEngineFactory find(DatasetGraph graphStore, Context context2) {
        for (UpdateEngineFactory f : this.factories) {
            if (!f.accept(graphStore, context2)) continue;
            return f;
        }
        return null;
    }

    public static void addFactory(UpdateEngineFactory f) {
        UpdateEngineRegistry.get().add(f);
    }

    public void add(UpdateEngineFactory f) {
        this.factories.add(0, f);
    }

    public static void removeFactory(UpdateEngineFactory f) {
        UpdateEngineRegistry.get().remove(f);
    }

    public void remove(UpdateEngineFactory f) {
        this.factories.remove(f);
    }

    public List<UpdateEngineFactory> factories() {
        return this.factories;
    }

    public static boolean containsFactory(UpdateEngineFactory f) {
        return UpdateEngineRegistry.get().contains(f);
    }

    public boolean contains(UpdateEngineFactory f) {
        return this.factories.contains(f);
    }

    static {
        UpdateEngineRegistry.init();
        registry = null;
    }
}

