/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex;

import java.io.InputStream;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterTTL;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.shex.ShexMap;
import org.apache.jena.shex.ShexSchema;
import org.apache.jena.shex.ShexShape;
import org.apache.jena.shex.parser.ShExC;
import org.apache.jena.shex.parser.ShExJ;
import org.apache.jena.shex.sys.SysShex;
import org.apache.jena.sys.JenaSystem;

public class Shex {
    public static Node FOCUS;

    public static ShexSchema schemaFromString(String inputStr) {
        return Shex.schemaFromString(inputStr, null);
    }

    public static ShexSchema schemaFromString(String inputStr, String baseURI) {
        ShexSchema shapes = ShExC.parse(new StringReader(inputStr), baseURI);
        return shapes;
    }

    public static ShexSchema readSchema(String filenameOrURL) {
        return Shex.readSchema(filenameOrURL, null);
    }

    public static ShexSchema readSchema(String filenameOrURL, String base) {
        TypedInputStream input = RDFDataMgr.open((String)filenameOrURL);
        String parserBase = base != null ? base : IRILib.filenameToIRI((String)filenameOrURL);
        ShexSchema shapes = ShExC.parse((InputStream)input, IRILib.filenameToIRI((String)filenameOrURL), parserBase);
        return shapes;
    }

    public static void printSchema(ShexSchema shapes) {
        IndentedWriter iOut = IndentedWriter.clone((IndentedWriter)IndentedWriter.stdout);
        iOut.setLinePrefix("");
        HashSet<String> visited = new HashSet<String>();
        if (shapes.getSource() != null) {
            visited.add(shapes.getSource());
        }
        Shex.printSchema(iOut, shapes, visited);
    }

    private static void printSchema(IndentedWriter iOut, ShexSchema shapes, Set<String> visited) {
        boolean havePrinted = false;
        if (!shapes.getPrefixMap().isEmpty()) {
            RiotLib.writePrefixes((IndentedWriter)iOut, (PrefixMap)shapes.getPrefixMap(), (boolean)true);
            havePrinted = true;
        }
        if (shapes.hasImports()) {
            if (havePrinted) {
                iOut.println();
            }
            shapes.getImports().forEach(iriStr -> {
                String pname = shapes.getPrefixMap().abbreviate(iriStr);
                if (pname == null) {
                    iOut.printf("IMPORT <%s>\n", new Object[]{iriStr});
                } else {
                    iOut.printf("IMPORT %s\n", new Object[]{pname});
                }
            });
            havePrinted = true;
        }
        if (!shapes.getShapes().isEmpty()) {
            boolean shapePrinted = false;
            NodeFormatterTTL nFmt = new NodeFormatterTTL(null, shapes.getPrefixMap());
            for (ShexShape shape : shapes.getShapes()) {
                if (havePrinted) {
                    iOut.println();
                }
                shape.print(iOut, (NodeFormatter)nFmt);
                havePrinted = true;
            }
        }
        if (shapes.hasImports()) {
            if (havePrinted) {
                iOut.println();
            }
            shapes.getImports().forEach(iriStr -> {
                if (visited.contains(iriStr)) {
                    return;
                }
                visited.add((String)iriStr);
                String prefix = iOut.getLinePrefix();
                iOut.println("Import = <" + iriStr + ">");
                iOut.incIndent(4);
                try {
                    ShexSchema imports = Shex.readSchema(iriStr);
                    iOut.setLinePrefix(prefix + "I");
                    Shex.printSchema(iOut, imports, visited);
                }
                catch (Exception ex) {
                    iOut.println("Failed to read shapes: " + ex.getMessage());
                }
                finally {
                    iOut.setLinePrefix(prefix);
                    iOut.decIndent(4);
                }
            });
            havePrinted = true;
        }
        iOut.flush();
    }

    public static ShexMap readShapeMap(String filename) {
        return Shex.readShapeMap(filename, IRILib.filenameToIRI((String)filename));
    }

    public static ShexMap readShapeMap(String filename, String baseURI) {
        InputStream input = IO.openFile((String)filename);
        return Shex.readShapeMap(input, baseURI);
    }

    public static ShexMap readShapeMap(InputStream input, String baseURI) {
        return ShExC.parseShapeMap(input, baseURI);
    }

    public static ShexMap shapeMapFromString(String inputStr, String baseURI) {
        return ShExC.parseShapeMap(new StringReader(inputStr), baseURI);
    }

    public static ShexMap readShapeMapJson(String filenameOrURL) {
        TypedInputStream in = RDFDataMgr.open((String)filenameOrURL);
        return Shex.readShapeMapJson(in.getInputStream());
    }

    public static ShexMap readShapeMapJson(InputStream input) {
        return ShExJ.readShapeMapJson(input);
    }

    static {
        JenaSystem.init();
        FOCUS = SysShex.focusNode;
    }
}

