/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.data;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;

public class ConnectSchema
implements Schema {
    private static final Map<Schema.Type, List<Class>> SCHEMA_TYPE_CLASSES = new HashMap<Schema.Type, List<Class>>();
    private static final Map<String, List<Class>> LOGICAL_TYPE_CLASSES = new HashMap<String, List<Class>>();
    private static final Map<Class<?>, Schema.Type> JAVA_CLASS_SCHEMA_TYPES = new HashMap();
    private final Schema.Type type;
    private final boolean optional;
    private final Object defaultValue;
    private final List<Field> fields;
    private final Map<String, Field> fieldsByName;
    private final Schema keySchema;
    private final Schema valueSchema;
    private final String name;
    private final Integer version;
    private final String doc;
    private final Map<String, String> parameters;

    public ConnectSchema(Schema.Type type, boolean optional, Object defaultValue, String name, Integer version, String doc, Map<String, String> parameters, List<Field> fields, Schema keySchema, Schema valueSchema) {
        this.type = type;
        this.optional = optional;
        this.defaultValue = defaultValue;
        this.name = name;
        this.version = version;
        this.doc = doc;
        this.parameters = parameters;
        this.fields = fields;
        if (this.fields != null && this.type == Schema.Type.STRUCT) {
            this.fieldsByName = new HashMap<String, Field>();
            for (Field field : fields) {
                this.fieldsByName.put(field.name(), field);
            }
        } else {
            this.fieldsByName = null;
        }
        this.keySchema = keySchema;
        this.valueSchema = valueSchema;
    }

    public ConnectSchema(Schema.Type type, boolean optional, Object defaultValue, String name, Integer version, String doc) {
        this(type, optional, defaultValue, name, version, doc, null, null, null, null);
    }

    public ConnectSchema(Schema.Type type) {
        this(type, false, null, null, null, null);
    }

    @Override
    public Schema.Type type() {
        return this.type;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public Object defaultValue() {
        return this.defaultValue;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Integer version() {
        return this.version;
    }

    @Override
    public String doc() {
        return this.doc;
    }

    @Override
    public Map<String, String> parameters() {
        return this.parameters;
    }

    @Override
    public List<Field> fields() {
        if (this.type != Schema.Type.STRUCT) {
            throw new DataException("Cannot list fields on non-struct type");
        }
        return this.fields;
    }

    @Override
    public Field field(String fieldName) {
        if (this.type != Schema.Type.STRUCT) {
            throw new DataException("Cannot look up fields on non-struct type");
        }
        return this.fieldsByName.get(fieldName);
    }

    @Override
    public Schema keySchema() {
        if (this.type != Schema.Type.MAP) {
            throw new DataException("Cannot look up key schema on non-map type");
        }
        return this.keySchema;
    }

    @Override
    public Schema valueSchema() {
        if (this.type != Schema.Type.MAP && this.type != Schema.Type.ARRAY) {
            throw new DataException("Cannot look up value schema on non-array and non-map type");
        }
        return this.valueSchema;
    }

    public static void validateValue(Schema schema, Object value) {
        if (value == null) {
            if (!schema.isOptional()) {
                throw new DataException("Invalid value: null used for required field");
            }
            return;
        }
        List<Class> expectedClasses = LOGICAL_TYPE_CLASSES.get(schema.name());
        if (expectedClasses == null) {
            expectedClasses = SCHEMA_TYPE_CLASSES.get((Object)schema.type());
        }
        if (expectedClasses == null) {
            throw new DataException("Invalid Java object for schema type " + (Object)((Object)schema.type()) + ": " + value.getClass());
        }
        boolean foundMatch = false;
        for (Class expectedClass : expectedClasses) {
            if (!expectedClass.isInstance(value)) continue;
            foundMatch = true;
            break;
        }
        if (!foundMatch) {
            throw new DataException("Invalid Java object for schema type " + (Object)((Object)schema.type()) + ": " + value.getClass());
        }
        switch (schema.type()) {
            case STRUCT: {
                Struct struct = (Struct)value;
                if (!struct.schema().equals(schema)) {
                    throw new DataException("Struct schemas do not match.");
                }
                struct.validate();
                break;
            }
            case ARRAY: {
                List array = (List)value;
                for (Object entry : array) {
                    ConnectSchema.validateValue(schema.valueSchema(), entry);
                }
                break;
            }
            case MAP: {
                Map map = (Map)value;
                for (Map.Entry entry : map.entrySet()) {
                    ConnectSchema.validateValue(schema.keySchema(), entry.getKey());
                    ConnectSchema.validateValue(schema.valueSchema(), entry.getValue());
                }
                break;
            }
        }
    }

    public void validateValue(Object value) {
        ConnectSchema.validateValue(this, value);
    }

    @Override
    public ConnectSchema schema() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectSchema schema = (ConnectSchema)o;
        return Objects.equals(this.optional, schema.optional) && Objects.equals((Object)this.type, (Object)schema.type) && Objects.equals(this.defaultValue, schema.defaultValue) && Objects.equals(this.fields, schema.fields) && Objects.equals(this.keySchema, schema.keySchema) && Objects.equals(this.valueSchema, schema.valueSchema) && Objects.equals(this.name, schema.name) && Objects.equals(this.version, schema.version) && Objects.equals(this.doc, schema.doc) && Objects.equals(this.parameters, schema.parameters);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.optional, this.defaultValue, this.fields, this.keySchema, this.valueSchema, this.name, this.version, this.doc, this.parameters});
    }

    public String toString() {
        if (this.name != null) {
            return "Schema{" + this.name + ":" + (Object)((Object)this.type) + "}";
        }
        return "Schema{" + (Object)((Object)this.type) + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schema.Type schemaType(Class<?> klass) {
        Map<Class<?>, Schema.Type> map = JAVA_CLASS_SCHEMA_TYPES;
        synchronized (map) {
            Schema.Type schemaType = JAVA_CLASS_SCHEMA_TYPES.get(klass);
            if (schemaType != null) {
                return schemaType;
            }
            for (Map.Entry<Class<?>, Schema.Type> entry : JAVA_CLASS_SCHEMA_TYPES.entrySet()) {
                try {
                    klass.asSubclass(entry.getKey());
                    JAVA_CLASS_SCHEMA_TYPES.put(klass, entry.getValue());
                    return entry.getValue();
                }
                catch (ClassCastException e) {
                }
            }
        }
        return null;
    }

    static {
        SCHEMA_TYPE_CLASSES.put(Schema.Type.INT8, Arrays.asList(Byte.class));
        SCHEMA_TYPE_CLASSES.put(Schema.Type.INT16, Arrays.asList(Short.class));
        SCHEMA_TYPE_CLASSES.put(Schema.Type.INT32, Arrays.asList(Integer.class));
        SCHEMA_TYPE_CLASSES.put(Schema.Type.INT64, Arrays.asList(Long.class));
        SCHEMA_TYPE_CLASSES.put(Schema.Type.FLOAT32, Arrays.asList(Float.class));
        SCHEMA_TYPE_CLASSES.put(Schema.Type.FLOAT64, Arrays.asList(Double.class));
        SCHEMA_TYPE_CLASSES.put(Schema.Type.BOOLEAN, Arrays.asList(Boolean.class));
        SCHEMA_TYPE_CLASSES.put(Schema.Type.STRING, Arrays.asList(String.class));
        SCHEMA_TYPE_CLASSES.put(Schema.Type.BYTES, Arrays.asList(byte[].class, ByteBuffer.class));
        SCHEMA_TYPE_CLASSES.put(Schema.Type.ARRAY, Arrays.asList(List.class));
        SCHEMA_TYPE_CLASSES.put(Schema.Type.MAP, Arrays.asList(Map.class));
        SCHEMA_TYPE_CLASSES.put(Schema.Type.STRUCT, Arrays.asList(Struct.class));
        for (Map.Entry<Schema.Type, List<Class>> schemaClasses : SCHEMA_TYPE_CLASSES.entrySet()) {
            for (Class schemaClass : schemaClasses.getValue()) {
                JAVA_CLASS_SCHEMA_TYPES.put(schemaClass, schemaClasses.getKey());
            }
        }
        LOGICAL_TYPE_CLASSES.put("org.apache.kafka.connect.data.Decimal", Arrays.asList(BigDecimal.class));
        LOGICAL_TYPE_CLASSES.put("org.apache.kafka.connect.data.Date", Arrays.asList(Date.class));
        LOGICAL_TYPE_CLASSES.put("org.apache.kafka.connect.data.Time", Arrays.asList(Date.class));
        LOGICAL_TYPE_CLASSES.put("org.apache.kafka.connect.data.Timestamp", Arrays.asList(Date.class));
    }
}

