/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.module.blackbird.BlackbirdModule;
import java.util.Collections;
import java.util.Set;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;

public class JsonDeserializer
implements Deserializer<JsonNode> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JsonDeserializer() {
        this(Collections.emptySet(), new JsonNodeFactory(true), true);
    }

    JsonDeserializer(Set<DeserializationFeature> deserializationFeatures, JsonNodeFactory jsonNodeFactory, boolean enableBlackbird) {
        this.objectMapper.enable(new JsonParser.Feature[]{JsonReadFeature.ALLOW_LEADING_ZEROS_FOR_NUMBERS.mappedFeature()});
        deserializationFeatures.forEach(arg_0 -> ((ObjectMapper)this.objectMapper).enable(arg_0));
        this.objectMapper.setNodeFactory(jsonNodeFactory);
        if (enableBlackbird) {
            this.objectMapper.registerModule((Module)new BlackbirdModule());
        }
    }

    public JsonNode deserialize(String topic, byte[] bytes) {
        JsonNode data;
        if (bytes == null) {
            return null;
        }
        try {
            data = this.objectMapper.readTree(bytes);
        }
        catch (Exception e) {
            throw new SerializationException("Error deserializing message to JSON in topic " + topic);
        }
        return data;
    }
}

