/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.SimpleHeaderConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerConfig
extends AbstractConfig {
    private static final Logger log = LoggerFactory.getLogger(WorkerConfig.class);
    private static final Pattern COMMA_WITH_WHITESPACE = Pattern.compile("\\s*,\\s*");
    public static final String BOOTSTRAP_SERVERS_CONFIG = "bootstrap.servers";
    public static final String BOOTSTRAP_SERVERS_DOC = "A list of host/port pairs to use for establishing the initial connection to the Kafka cluster. The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers. This list should be in the form <code>host1:port1,host2:port2,...</code>. Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).";
    public static final String BOOTSTRAP_SERVERS_DEFAULT = "localhost:9092";
    public static final String CLIENT_DNS_LOOKUP_CONFIG = "client.dns.lookup";
    public static final String CLIENT_DNS_LOOKUP_DOC = "<p>Controls how the client uses DNS lookups.</p><p>If set to <code>use_all_dns_ips</code> then, when the lookup returns multiple IP addresses for a hostname, they will all be attempted to connect to before failing the connection. Applies to both bootstrap and advertised servers.</p><p>If the value is <code>resolve_canonical_bootstrap_servers_only</code> each entry will be resolved and expanded into a list of canonical names.</p>";
    public static final String KEY_CONVERTER_CLASS_CONFIG = "key.converter";
    public static final String KEY_CONVERTER_CLASS_DOC = "Converter class used to convert between Kafka Connect format and the serialized form that is written to Kafka. This controls the format of the keys in messages written to or read from Kafka, and since this is independent of connectors it allows any connector to work with any serialization format. Examples of common formats include JSON and Avro.";
    public static final String VALUE_CONVERTER_CLASS_CONFIG = "value.converter";
    public static final String VALUE_CONVERTER_CLASS_DOC = "Converter class used to convert between Kafka Connect format and the serialized form that is written to Kafka. This controls the format of the values in messages written to or read from Kafka, and since this is independent of connectors it allows any connector to work with any serialization format. Examples of common formats include JSON and Avro.";
    public static final String HEADER_CONVERTER_CLASS_CONFIG = "header.converter";
    public static final String HEADER_CONVERTER_CLASS_DOC = "HeaderConverter class used to convert between Kafka Connect format and the serialized form that is written to Kafka. This controls the format of the header values in messages written to or read from Kafka, and since this is independent of connectors it allows any connector to work with any serialization format. Examples of common formats include JSON and Avro. By default, the SimpleHeaderConverter is used to serialize header values to strings and deserialize them by inferring the schemas.";
    public static final String HEADER_CONVERTER_CLASS_DEFAULT = SimpleHeaderConverter.class.getName();
    @Deprecated
    public static final String INTERNAL_KEY_CONVERTER_CLASS_CONFIG = "internal.key.converter";
    public static final String INTERNAL_KEY_CONVERTER_CLASS_DOC = "Converter class used to convert between Kafka Connect format and the serialized form that is written to Kafka. This controls the format of the keys in messages written to or read from Kafka, and since this is independent of connectors it allows any connector to work with any serialization format. Examples of common formats include JSON and Avro. This setting controls the format used for internal bookkeeping data used by the framework, such as configs and offsets, so users can typically use any functioning Converter implementation. Deprecated; will be removed in an upcoming version.";
    @Deprecated
    public static final String INTERNAL_VALUE_CONVERTER_CLASS_CONFIG = "internal.value.converter";
    public static final String INTERNAL_VALUE_CONVERTER_CLASS_DOC = "Converter class used to convert between Kafka Connect format and the serialized form that is written to Kafka. This controls the format of the values in messages written to or read from Kafka, and since this is independent of connectors it allows any connector to work with any serialization format. Examples of common formats include JSON and Avro. This setting controls the format used for internal bookkeeping data used by the framework, such as configs and offsets, so users can typically use any functioning Converter implementation. Deprecated; will be removed in an upcoming version.";
    private static final Class<? extends Converter> INTERNAL_CONVERTER_DEFAULT = JsonConverter.class;
    public static final String TASK_SHUTDOWN_GRACEFUL_TIMEOUT_MS_CONFIG = "task.shutdown.graceful.timeout.ms";
    private static final String TASK_SHUTDOWN_GRACEFUL_TIMEOUT_MS_DOC = "Amount of time to wait for tasks to shutdown gracefully. This is the total amount of time, not per task. All task have shutdown triggered, then they are waited on sequentially.";
    private static final String TASK_SHUTDOWN_GRACEFUL_TIMEOUT_MS_DEFAULT = "5000";
    public static final String OFFSET_COMMIT_INTERVAL_MS_CONFIG = "offset.flush.interval.ms";
    private static final String OFFSET_COMMIT_INTERVAL_MS_DOC = "Interval at which to try committing offsets for tasks.";
    public static final long OFFSET_COMMIT_INTERVAL_MS_DEFAULT = 60000L;
    public static final String OFFSET_COMMIT_TIMEOUT_MS_CONFIG = "offset.flush.timeout.ms";
    private static final String OFFSET_COMMIT_TIMEOUT_MS_DOC = "Maximum number of milliseconds to wait for records to flush and partition offset data to be committed to offset storage before cancelling the process and restoring the offset data to be committed in a future attempt.";
    public static final long OFFSET_COMMIT_TIMEOUT_MS_DEFAULT = 5000L;
    @Deprecated
    public static final String REST_HOST_NAME_CONFIG = "rest.host.name";
    private static final String REST_HOST_NAME_DOC = "Hostname for the REST API. If this is set, it will only bind to this interface.";
    @Deprecated
    public static final String REST_PORT_CONFIG = "rest.port";
    private static final String REST_PORT_DOC = "Port for the REST API to listen on.";
    public static final int REST_PORT_DEFAULT = 8083;
    public static final String LISTENERS_CONFIG = "listeners";
    private static final String LISTENERS_DOC = "List of comma-separated URIs the REST API will listen on. The supported protocols are HTTP and HTTPS.\n Specify hostname as 0.0.0.0 to bind to all interfaces.\n Leave hostname empty to bind to default interface.\n Examples of legal listener lists: HTTP://myhost:8083,HTTPS://myhost:8084";
    public static final String REST_ADVERTISED_HOST_NAME_CONFIG = "rest.advertised.host.name";
    private static final String REST_ADVERTISED_HOST_NAME_DOC = "If this is set, this is the hostname that will be given out to other workers to connect to.";
    public static final String REST_ADVERTISED_PORT_CONFIG = "rest.advertised.port";
    private static final String REST_ADVERTISED_PORT_DOC = "If this is set, this is the port that will be given out to other workers to connect to.";
    public static final String REST_ADVERTISED_LISTENER_CONFIG = "rest.advertised.listener";
    private static final String REST_ADVERTISED_LISTENER_DOC = "Sets the advertised listener (HTTP or HTTPS) which will be given to other workers to use.";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN_CONFIG = "access.control.allow.origin";
    protected static final String ACCESS_CONTROL_ALLOW_ORIGIN_DOC = "Value to set the Access-Control-Allow-Origin header to for REST API requests.To enable cross origin access, set this to the domain of the application that should be permitted to access the API, or '*' to allow access from any domain. The default value only allows access from the domain of the REST API.";
    protected static final String ACCESS_CONTROL_ALLOW_ORIGIN_DEFAULT = "";
    public static final String ACCESS_CONTROL_ALLOW_METHODS_CONFIG = "access.control.allow.methods";
    protected static final String ACCESS_CONTROL_ALLOW_METHODS_DOC = "Sets the methods supported for cross origin requests by setting the Access-Control-Allow-Methods header. The default value of the Access-Control-Allow-Methods header allows cross origin requests for GET, POST and HEAD.";
    protected static final String ACCESS_CONTROL_ALLOW_METHODS_DEFAULT = "";
    public static final String PLUGIN_PATH_CONFIG = "plugin.path";
    protected static final String PLUGIN_PATH_DOC = "List of paths separated by commas (,) that contain plugins (connectors, converters, transformations). The list should consist of top level directories that include any combination of: \na) directories immediately containing jars with plugins and their dependencies\nb) uber-jars with plugins and their dependencies\nc) directories immediately containing the package directory structure of classes of plugins and their dependencies\nNote: symlinks will be followed to discover dependencies or plugins.\nExamples: plugin.path=/usr/local/share/java,/usr/local/share/kafka/plugins,/opt/connectors";
    public static final String CONFIG_PROVIDERS_CONFIG = "config.providers";
    protected static final String CONFIG_PROVIDERS_DOC = "Comma-separated names of <code>ConfigProvider</code> classes, loaded and used in the order specified. Implementing the interface  <code>ConfigProvider</code> allows you to replace variable references in connector configurations, such as for externalized secrets. ";
    public static final String REST_EXTENSION_CLASSES_CONFIG = "rest.extension.classes";
    protected static final String REST_EXTENSION_CLASSES_DOC = "Comma-separated names of <code>ConnectRestExtension</code> classes, loaded and called in the order specified. Implementing the interface  <code>ConnectRestExtension</code> allows you to inject into Connect's REST API user defined resources like filters. Typically used to add custom capability like logging, security, etc. ";
    public static final String METRICS_SAMPLE_WINDOW_MS_CONFIG = "metrics.sample.window.ms";
    public static final String METRICS_NUM_SAMPLES_CONFIG = "metrics.num.samples";
    public static final String METRICS_RECORDING_LEVEL_CONFIG = "metrics.recording.level";
    public static final String METRIC_REPORTER_CLASSES_CONFIG = "metric.reporters";

    protected static ConfigDef baseConfigDef() {
        return new ConfigDef().define(BOOTSTRAP_SERVERS_CONFIG, ConfigDef.Type.LIST, (Object)BOOTSTRAP_SERVERS_DEFAULT, ConfigDef.Importance.HIGH, BOOTSTRAP_SERVERS_DOC).define(CLIENT_DNS_LOOKUP_CONFIG, ConfigDef.Type.STRING, (Object)ClientDnsLookup.DEFAULT.toString(), (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{ClientDnsLookup.DEFAULT.toString(), ClientDnsLookup.USE_ALL_DNS_IPS.toString(), ClientDnsLookup.RESOLVE_CANONICAL_BOOTSTRAP_SERVERS_ONLY.toString()}), ConfigDef.Importance.MEDIUM, CLIENT_DNS_LOOKUP_DOC).define(KEY_CONVERTER_CLASS_CONFIG, ConfigDef.Type.CLASS, ConfigDef.Importance.HIGH, KEY_CONVERTER_CLASS_DOC).define(VALUE_CONVERTER_CLASS_CONFIG, ConfigDef.Type.CLASS, ConfigDef.Importance.HIGH, VALUE_CONVERTER_CLASS_DOC).define(INTERNAL_KEY_CONVERTER_CLASS_CONFIG, ConfigDef.Type.CLASS, INTERNAL_CONVERTER_DEFAULT, ConfigDef.Importance.LOW, INTERNAL_KEY_CONVERTER_CLASS_DOC).define(INTERNAL_VALUE_CONVERTER_CLASS_CONFIG, ConfigDef.Type.CLASS, INTERNAL_CONVERTER_DEFAULT, ConfigDef.Importance.LOW, INTERNAL_VALUE_CONVERTER_CLASS_DOC).define(TASK_SHUTDOWN_GRACEFUL_TIMEOUT_MS_CONFIG, ConfigDef.Type.LONG, (Object)TASK_SHUTDOWN_GRACEFUL_TIMEOUT_MS_DEFAULT, ConfigDef.Importance.LOW, TASK_SHUTDOWN_GRACEFUL_TIMEOUT_MS_DOC).define(OFFSET_COMMIT_INTERVAL_MS_CONFIG, ConfigDef.Type.LONG, (Object)60000L, ConfigDef.Importance.LOW, OFFSET_COMMIT_INTERVAL_MS_DOC).define(OFFSET_COMMIT_TIMEOUT_MS_CONFIG, ConfigDef.Type.LONG, (Object)5000L, ConfigDef.Importance.LOW, OFFSET_COMMIT_TIMEOUT_MS_DOC).define(REST_HOST_NAME_CONFIG, ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, REST_HOST_NAME_DOC).define(REST_PORT_CONFIG, ConfigDef.Type.INT, (Object)8083, ConfigDef.Importance.LOW, REST_PORT_DOC).define(LISTENERS_CONFIG, ConfigDef.Type.LIST, null, ConfigDef.Importance.LOW, LISTENERS_DOC).define(REST_ADVERTISED_HOST_NAME_CONFIG, ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, REST_ADVERTISED_HOST_NAME_DOC).define(REST_ADVERTISED_PORT_CONFIG, ConfigDef.Type.INT, null, ConfigDef.Importance.LOW, REST_ADVERTISED_PORT_DOC).define(REST_ADVERTISED_LISTENER_CONFIG, ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, REST_ADVERTISED_LISTENER_DOC).define(ACCESS_CONTROL_ALLOW_ORIGIN_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, ACCESS_CONTROL_ALLOW_ORIGIN_DOC).define(ACCESS_CONTROL_ALLOW_METHODS_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, ACCESS_CONTROL_ALLOW_METHODS_DOC).define(PLUGIN_PATH_CONFIG, ConfigDef.Type.LIST, null, ConfigDef.Importance.LOW, PLUGIN_PATH_DOC).define(METRICS_SAMPLE_WINDOW_MS_CONFIG, ConfigDef.Type.LONG, (Object)30000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, "The window of time a metrics sample is computed over.").define(METRICS_NUM_SAMPLES_CONFIG, ConfigDef.Type.INT, (Object)2, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, "The number of samples maintained to compute metrics.").define(METRICS_RECORDING_LEVEL_CONFIG, ConfigDef.Type.STRING, (Object)Sensor.RecordingLevel.INFO.toString(), (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{Sensor.RecordingLevel.INFO.toString(), Sensor.RecordingLevel.DEBUG.toString()}), ConfigDef.Importance.LOW, "The highest recording level for metrics.").define(METRIC_REPORTER_CLASSES_CONFIG, ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.LOW, "A list of classes to use as metrics reporters. Implementing the <code>org.apache.kafka.common.metrics.MetricsReporter</code> interface allows plugging in classes that will be notified of new metric creation. The JmxReporter is always included to register JMX statistics.").define("ssl.client.auth", ConfigDef.Type.STRING, (Object)"none", ConfigDef.Importance.LOW, "Configures kafka broker to request client authentication. The following settings are common:  <ul> <li><code>ssl.client.auth=required</code> If set to required client authentication is required. <li><code>ssl.client.auth=requested</code> This means client authentication is optional. unlike requested , if this option is set client can choose not to provide authentication information about itself <li><code>ssl.client.auth=none</code> This means client authentication is not needed.").define(HEADER_CONVERTER_CLASS_CONFIG, ConfigDef.Type.CLASS, (Object)HEADER_CONVERTER_CLASS_DEFAULT, ConfigDef.Importance.LOW, HEADER_CONVERTER_CLASS_DOC).define(CONFIG_PROVIDERS_CONFIG, ConfigDef.Type.LIST, Collections.emptyList(), ConfigDef.Importance.LOW, CONFIG_PROVIDERS_DOC).define(REST_EXTENSION_CLASSES_CONFIG, ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.LOW, REST_EXTENSION_CLASSES_DOC);
    }

    private void logInternalConverterDeprecationWarnings(Map<String, String> props) {
        String[] deprecatedConfigs;
        for (String config : deprecatedConfigs = new String[]{INTERNAL_KEY_CONVERTER_CLASS_CONFIG, INTERNAL_VALUE_CONVERTER_CLASS_CONFIG}) {
            if (!props.containsKey(config)) continue;
            Class internalConverterClass = this.getClass(config);
            this.logDeprecatedProperty(config, internalConverterClass.getCanonicalName(), INTERNAL_CONVERTER_DEFAULT.getCanonicalName(), null);
            if (!internalConverterClass.equals(INTERNAL_CONVERTER_DEFAULT)) continue;
            for (Map.Entry propEntry : this.originalsWithPrefix(config + ".").entrySet()) {
                String prop = (String)propEntry.getKey();
                String propValue = propEntry.getValue().toString();
                String defaultValue = "schemas.enable".equals(prop) ? "false" : null;
                this.logDeprecatedProperty(config + "." + prop, propValue, defaultValue, config);
            }
        }
    }

    private void logDeprecatedProperty(String propName, String propValue, String defaultValue, String prefix) {
        String prefixNotice;
        String string = prefixNotice = prefix != null ? " (along with all configuration for '" + prefix + "')" : "";
        if (defaultValue != null && defaultValue.equalsIgnoreCase(propValue)) {
            log.info("Worker configuration property '{}'{} is deprecated and may be removed in an upcoming release. The specified value matches the default, so this property can be safely removed from the worker configuration.", new Object[]{propName, prefixNotice, propValue});
        } else if (defaultValue != null) {
            log.warn("Worker configuration property '{}'{} is deprecated and may be removed in an upcoming release. The specified value '{}' does NOT match the default and recommended value '{}'.", new Object[]{propName, prefixNotice, propValue, defaultValue});
        } else {
            log.warn("Worker configuration property '{}'{} is deprecated and may be removed in an upcoming release.", (Object)propName, (Object)prefixNotice);
        }
    }

    protected Map<String, Object> postProcessParsedConfig(Map<String, Object> parsedValues) {
        return CommonClientConfigs.postProcessReconnectBackoffConfigs((AbstractConfig)this, parsedValues);
    }

    public static List<String> pluginLocations(Map<String, String> props) {
        String locationList = props.get(PLUGIN_PATH_CONFIG);
        return locationList == null ? new ArrayList<String>() : Arrays.asList(COMMA_WITH_WHITESPACE.split(locationList.trim(), -1));
    }

    public WorkerConfig(ConfigDef definition, Map<String, String> props) {
        super(definition, props);
        this.logInternalConverterDeprecationWarnings(props);
    }
}

